let list = [
    'Ябълки',
    'Моркови',
    'Портакали',
    'Праскови',
    'Мандарини',
    'Моркови',
    'Киви'
];

// разделяне на списък на части 
/*
[
    [
        "Ябълки",
        "Моркови",
        "Портакали"
    ],
    [
        "Праскови",
        "Мандарини",
        "Моркови"
    ],
    [
        "Киви"
    ]
]
*/
let chunkedList = _.chunk(list,3);
// console.log(chunkedList);

// взимане на различните елементи м/у два списъка
// ['Ябълки', 'Портакали']
let diffrenceBetweenLists = _.difference(list, ['Моркови', 'Праскови', 'Киви', 'Мандарини']);
// console.log(diffrenceBetweenLists);

// конкатиниране 
// Ябълки, Моркови, Портакали, Праскови, Мандарини, Моркови, Киви
let concatinatedListStr = _.join(list, ', ');
// console.log(concatinatedListStr)

// взимане без
// ['Ябълки', 'Портакали', 'Праскови', 'Мандарини']
let listWithoutElements = _.without(list, 'Моркови', 'Киви', 'Портокали');
// console.log(listWithoutElements);

// взимаме само уникалните елементи
// ['Ябълки', 'Моркови', 'Портакали', 'Праскови', 'Мандарини', 'Киви']
let uniqueElements = _.uniq(list);
// console.log(uniqueElements)


// Освен за операции на листове, Lodash има и други функции

const dog = {
    legs: 4,
    name: "Krum",
    fur: {
        striped: {
            firstColor: "red",
            secondColor: "blue"
        }
    }
}

const cat = {
    legs: 4,
    name: "Tervel",
    fur: "white"
}

// console.log(dog.fur.striped.firstColor);
// console.log(cat.fur.striped.firstColor); // main.js:73 Uncaught TypeError: Cannot read properties of undefined (reading 'firstColor') at main.js:73:29
// console.log(_.get(cat, "fur.striped.firstColor", "black"))


// Списък с топ 10 функции на lodash
// 1. assign

let someObject = {
    "nqkakvoProperty" : "nqkakvoValue", 
    "drun" : "drun"
}

let newSomeObject = {
    "catName" : "Krum"
}
let otherSomeObject = {
    "dogName" : "Tervel",
    "drun" : "Novo value drun"
}

/*
{
    "nqkakvoProperty": "nqkakvoValue",
    "drun": "Novo value drun",
    "catName": "Krum",
    "dogName": "Tervel"
}
*/
// console.log(_.assign(someObject, newSomeObject, otherSomeObject)) 

// 2. times - получава функци и я извиква няколко пъти
function randomIntFromInterval() {
    return _.random(0,4);
}

function getRandomNameList(namesCount) {
    let randomIndexes = _.times(namesCount, randomIntFromInterval);
    let result = [];
    let names = ["Tervel", "Krum", "Asparuh", "Kubrat", "Omurtag"];
    randomIndexes.forEach(index => {
        result.push(names[index]);
    });
   
    return result;
}

//  console.log(_.join(getRandomNameList(5), ', ')); // Asparuh, Asparuh, Kubrat, Kubrat, Krum

// 3. _.debounce извиква функция след определено време
var debounce_fun = _.debounce(function () {
    console.log('Called after 3 seconds!');
    }, 3000);
    
// debounce_fun();

// 4.  _.find 

var users = [
    { firstName: "John", lastName: "Doe", age: 28, gender: "male" },
    { firstName: "Jane", lastName: "Doe", age: 5, gender: "female" },
    { firstName: "Jim", lastName: "Carrey", age: 54, gender: "male" },
    { firstName: "Kate", lastName: "Winslet", age: 40, gender: "female" }
  ];
  
  var johnDoe = _.find(users, { lastName: "Doe", gender: "male" });
// console.log(johnDoe);
  
    // може да се подават и функции
  var underAgeUser = _.find(users, function(user) {
      return user.age < 18;
  });
//   console.log(underAgeUser);


// 5. _.get and ._set. + примера горе

var bar = { foo: { key: "foo" } };
_.set(bar, "foo.items[0]", "An item");

/*
{
    "foo": {
        "key": "foo",
        "items": [
            "An item"
        ]
    }
}
*/
// console.log(bar); 
// console.log(_.get(bar, "name", "John Doe")); // John Doe


// 6. _.deburr
// console.log(_.deburr("déjà vu"));
// console.log(_.deburr("Juan José"));
// console.log(_.deburr("Симéон"));


// 7. _.keyBy - взима обект със специално пропърти
var posts = [
    { id: "1abc", title: "First blog post", content: "..." },
    { id: "2abc", title: "Second blog post", content: "..." },
    { id: "34abc", title: "The blog post we want", content: "..." }
];

posts = _.keyBy(posts, "id"); // прави ги като мап с key id
// console.log(posts["34abc"]); // { id: "34abc", title: "The blog post we want", content: "..." }

// 8. _.reduce - филтрира по критерии 
// This helper function is one of the most used ones from Lodash. !!!!!

var users = [
    { name: "Tervel", age: 30, nationality:"BG" },
    { name: "Jane", age: 28 },
    { name: "Asparuh", age: 65, nationality:"BG" },
    { name: "Emily", age: 17 },
    { name: "Krum", age: 30, nationality:"BG" }
]

var reducedUsers = _.reduce(users, function (result, user) {
    if(user.age >= 18 && user.nationality === "BG") {
        (result[user.age] || (result[user.age] = [])).push(user);
    }
  
    return result;
}, {});
/*
{
    "30": [
        {
            "name": "Tervel",
            "age": 30,
            "nationality": "BG"
        },
        {
            "name": "Krum",
            "age": 30,
            "nationality": "BG"
        }
    ],
    "65": [
        {
            "name": "Asparuh",
            "age": 65,
            "nationality": "BG"
        }
    ]
}
*/
// console.log(reducedUsers);

// 9.  _.cloneDeep
var original = { foo: "bar" };
var copy = _.cloneDeep(original);
copy.foo = "new value";
// copy -> { foo: "new value" } 
// original -> { foo: "bar" } 

// 10 _. sortedUniq

var sortedArray = [1, 1, 2, 3, 3, 3, 5, 8, 8];
var result = _.sortedUniq(sortedArray);
// console.log(result); // -> [1, 2, 3, 5, 8]


// Други готини функции :)
const gameOfThronesCharacters = [
    {
      name: 'Ned Stark',
      age: 52
    },
    {
      name: 'Daenerys Targaryen',
      age: 15
    },
    {
      name: 'Jon Snow',
      age: 17
    },
    {
      name: 'Arya Stark',
      age: 12
    }
  ]
  
_.orderBy('age', 'desc', gameOfThronesCharacters)
// console.log(gameOfThronesCharacters)

// intersection
const goodGuys = ['Daenerys Targaryen' ,'Jon Snow' ,'Arya Stark' ]
const badGuys = ['Cersei Lannister' ,'Joffrey Lannister' ,'Daenerys Targaryen']
let intersectedCharcters = _.intersectionBy( goodGuys, badGuys);
// console.log(intersectedCharcters); // Daenerys Targaryen





// Много е лесно използването на няколко функции заедно:

let finalExampleUsers = [
    { name: 'Alex', email: 'alex@example.com', uid: '124234', userType: 'admin' },
    { name: 'Beau', email: null, userType: 'user', uid: '152335' },
    { name: 'Charlie', email: 'charlie@char.ly', userType: 'user', uid: '23221' },
    { name: 'Daytona', email: 'dave@dave.io', userType: 'user', uid: '234216' },
    { name: 'Elliott', email: 'elliott@example.com' }
  ]
  
  const getDomain = email => email.split('@')[1]
  
  const getEmailDomains = _.flow(
    (users) => _.map(users, user => user.email),
    (emails) => _.filter(emails,  function(elem) { return elem !== null; }),
    (emails) => _.map(emails, email =>getDomain(email)),
    _.uniq)

  let newUsers = getEmailDomains(finalExampleUsers);
//   console.log(newUsers) // ['example.com', 'char.ly', 'dave.io']