"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.configureApp = exports.createApp = void 0;
const core_1 = require("@nestjs/core");
const AppModule_1 = require("./AppModule");
const common_1 = require("@nestjs/common");
require('dotenv').config({ path: require('find-config')('.env') });
const logger = new common_1.Logger('main');
async function createApp() {
    return core_1.NestFactory.create(AppModule_1.AppModule);
}
exports.createApp = createApp;
async function configureApp(app) {
    app.useGlobalPipes(new common_1.ValidationPipe({
        transform: true,
        whitelist: true
    }));
    app.useGlobalInterceptors(new common_1.ClassSerializerInterceptor(app.get(core_1.Reflector)));
    if (require.main === module) {
        const port = process.env.SERVER_PORT || 3000;
        logger.log(`Starting server on port: ${port}`);
        await app.listen(port);
    }
}
exports.configureApp = configureApp;
createApp()
    .then(async (app) => configureApp(app))
    .then(() => logger.log(`Bootstrap configuration complete.`))
    .catch(e => {
    throw e;
});
//# sourceMappingURL=main.js.map