"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ActorRepository = void 0;
const common_1 = require("@nestjs/common");
const drivine_1 = require("@liberation-data/drivine");
let ActorRepository = class ActorRepository {
    constructor(persistenceManager, moviesForActor, coActorsForActor) {
        this.persistenceManager = persistenceManager;
        this.moviesForActor = moviesForActor;
        this.coActorsForActor = coActorsForActor;
    }
    async findByName(name) {
        const spec = new drivine_1.QuerySpecification().withStatement(this.moviesForActor).bind({ name: name });
        return this.persistenceManager.maybeGetOne(spec);
    }
    async listCoActors(name) {
        const spec = new drivine_1.QuerySpecification().withStatement(this.coActorsForActor).bind({ name: name });
        return this.persistenceManager.maybeGetOne(spec);
    }
};
ActorRepository = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, drivine_1.InjectPersistenceManager)()),
    __param(1, (0, drivine_1.InjectCypher)(__dirname, 'moviesForActor')),
    __param(2, (0, drivine_1.InjectCypher)(__dirname, 'coActorsForActor')),
    __metadata("design:paramtypes", [Object, Object, Object])
], ActorRepository);
exports.ActorRepository = ActorRepository;
//# sourceMappingURL=ActorRepository.js.map