import { Route } from './Route';
import { Cursor } from '@liberation-data/drivine/cursor/Cursor';
import { PersistenceManager } from '@liberation-data/drivine/manager/PersistenceManager';
import { CypherStatement } from '@liberation-data/drivine/query/Statement';
export declare class RouteRepository {
    readonly persistenceManager: PersistenceManager;
    readonly routesBetween: CypherStatement;
    constructor(persistenceManager: PersistenceManager, routesBetween: CypherStatement);
    findFastestBetween(start: string, destination: string): Promise<Route>;
    findRoutesBetween(start: string, destination: string): Promise<Route[]>;
    asyncRoutesBetween(start: string, destination: string): Promise<Cursor<Route>>;
}
