"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RouteRepository = void 0;
const common_1 = require("@nestjs/common");
const Route_1 = require("./Route");
const DrivineInjectionDecorators_1 = require("@liberation-data/drivine/DrivineInjectionDecorators");
const Transactional_1 = require("@liberation-data/drivine/transaction/Transactional");
const QuerySpecification_1 = require("@liberation-data/drivine/query/QuerySpecification");
const CursorSpecification_1 = require("@liberation-data/drivine/cursor/CursorSpecification");
let RouteRepository = class RouteRepository {
    constructor(persistenceManager, routesBetween) {
        this.persistenceManager = persistenceManager;
        this.routesBetween = routesBetween;
    }
    async findFastestBetween(start, destination) {
        return this.persistenceManager.getOne(new QuerySpecification_1.QuerySpecification()
            .withStatement(this.routesBetween)
            .bind([start, destination])
            .limit(1)
            .transform(Route_1.Route));
    }
    async findRoutesBetween(start, destination) {
        return this.persistenceManager.query(new QuerySpecification_1.QuerySpecification()
            .withStatement(this.routesBetween)
            .bind([start, destination])
            .transform(Route_1.Route));
    }
    async asyncRoutesBetween(start, destination) {
        return this.persistenceManager.openCursor(new CursorSpecification_1.CursorSpecification()
            .withStatement(this.routesBetween)
            .bind([start, destination])
            .batchSize(5)
            .transform(Route_1.Route));
    }
};
__decorate([
    (0, Transactional_1.Transactional)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String]),
    __metadata("design:returntype", Promise)
], RouteRepository.prototype, "findFastestBetween", null);
__decorate([
    (0, Transactional_1.Transactional)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String]),
    __metadata("design:returntype", Promise)
], RouteRepository.prototype, "findRoutesBetween", null);
__decorate([
    (0, Transactional_1.Transactional)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String]),
    __metadata("design:returntype", Promise)
], RouteRepository.prototype, "asyncRoutesBetween", null);
RouteRepository = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, DrivineInjectionDecorators_1.InjectPersistenceManager)()),
    __param(1, (0, DrivineInjectionDecorators_1.InjectCypher)(__dirname, 'routesBetween')),
    __metadata("design:paramtypes", [Object, Object])
], RouteRepository);
exports.RouteRepository = RouteRepository;
//# sourceMappingURL=RouteRepository.js.map