"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var UrbaniteRepository_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UrbaniteRepository = void 0;
const common_1 = require("@nestjs/common");
const DrivineInjectionDecorators_1 = require("@liberation-data/drivine/DrivineInjectionDecorators");
const Urbanite_1 = require("@/traffic/Urbanite");
const drivine_1 = require("@liberation-data/drivine");
const utils_1 = require("@liberation-data/drivine/utils");
let UrbaniteRepository = UrbaniteRepository_1 = class UrbaniteRepository {
    constructor(persistenceManager, saveUrbanite) {
        this.persistenceManager = persistenceManager;
        this.saveUrbanite = saveUrbanite;
        this.logger = new common_1.Logger(UrbaniteRepository_1.name);
    }
    async save(person) {
        if (this.persistenceManager.type == drivine_1.DatabaseType.NEO4J) {
            await this.neo4jSave(person);
        }
        else if (this.persistenceManager.type == drivine_1.DatabaseType.AGENS_GRAPH) {
            await this.agensGraphSave(person);
        }
    }
    async neo4jSave(person) {
        const urbaniteProps = utils_1.ObjectUtils.primitiveProps(person);
        const parameters = {
            urbaniteProps: urbaniteProps,
            metros: person.favoriteHaunts.map(it => it.name)
        };
        const statement = new drivine_1.QuerySpecification(this.saveUrbanite).bind(parameters);
        await this.persistenceManager.execute(statement);
    }
    async agensGraphSave(person) {
        this.logger.debug(`TODO: Implement save ${person}`);
        return Promise.resolve();
    }
};
__decorate([
    (0, drivine_1.Transactional)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Urbanite_1.Urbanite]),
    __metadata("design:returntype", Promise)
], UrbaniteRepository.prototype, "save", null);
UrbaniteRepository = UrbaniteRepository_1 = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, DrivineInjectionDecorators_1.InjectPersistenceManager)()),
    __param(1, (0, DrivineInjectionDecorators_1.InjectCypher)(__dirname, 'save-urbanite')),
    __metadata("design:paramtypes", [Object, Object])
], UrbaniteRepository);
exports.UrbaniteRepository = UrbaniteRepository;
//# sourceMappingURL=UrbaniteRepository.js.map