class Animal {
  public name: string;
  protected age: number;
  private species: string;
  readonly id: number;

  constructor(name: string, age: number, species: string, id: number) {
    this.name = name;
    this.age = age;
    this.species = species;
    this.id = id;
  }

  public speak(): string {
    return `My name is ${this.name} and I am a ${this.species}.`;
  }

  protected getAge(): number {
    return this.age;
  }
}
//------------------------------------------------------------------------------------------------------------------------------------------

// Define a subclass that extends Animal and adds a new method
class Dog extends Animal {
  public bark(): string {
    return "Woof, woof!";
  }
}

// Define an interface that defines a required method
interface Mammal {
  readonly animalNumberOfLegs: number;
  giveBirth(): void;
}

// Define a class that implements Mammal and adds a new method
class Cat implements Mammal {
  readonly animalNumberOfLegs: number;

  constructor(animalNumberOfLegs: number) {
    this.animalNumberOfLegs = animalNumberOfLegs;
  }

  //Example if it comented there is error
  giveBirth(): string {
    return "Kitten born!";
  }
}

// Create instances of Animal, Dog, and Cat classes
const animal = new Animal("Unknown", 5, "unknown", 1);
const dog = new Dog("Betoven", 3, "dog", 2);
const cat = new Cat(4);

console.log(dog.name); 
console.log(dog.bark()); 
console.log(cat.giveBirth()); 
//animal.id =100; //Error: Cannot assign to 'id' because it is a read-only property.
//cat.animalNumberOfLegs = 1; //Error: Cannot assign to 'animalNumberOfLegs' because it is a read-only property.

//------------------------------------------------------------------------------------------------------------------------------------------

interface Bird {
  name: string;
  age: number;
  species: string;
  id: number;
}

// Readonly<T> to create a readonly type, as shown below.
let myObject: Readonly<Bird> = {
  name: "Bird",
  age: 1,
  species: "default",
  id: 1
}

//Changeing properties of readonly object is not allowed
// myObject.name = "parrot";
// myObject.age = 4;
