//1 Generic functions:

function identity<T>(arg: T): T {
    return arg;
  }
  
  console.log(identity("Hello, I'm a function"));
  
//-----------------------------------------------------
//2 Generic classes:

class MyArray<T extends number> {
    private data: T[] = [];
  
    push(item: T) {
      this.data.push(item);
    }
  
    pop(): T | undefined {
      return this.data.pop();
    }
  }
  
  let myArray = new MyArray();
  myArray.push(1);
  myArray.push(8);
  console.log(myArray.pop());

//-----------------------------------------------------

//3 Generic interfaces:
interface MyObject<T = string>{
    data: T;
  }
  
  let myObject: MyObject = { data: "Hello, I'm an interface" };
  console.log(myObject.data);

//-----------------------------------------------------