class Animal1 {
    public name: string;
    protected age: number;
    private species: string;

    constructor(name: string, age: number, species: string) {
        this.name = name;
        this.age = age;
        this.species = species;
    }

    public speak(): void {
        console.log(`My name is ${this.name} and I am a ${this.species}.`);
    }

    protected getAge(): number {
        return this.age;
    }

    private getSpecies(): string {
        return this.species;
    }
}

class Animal2 {

    constructor(public name: string, protected age: number, private species: string) {
    }

    public speak(): void {
        console.log(`My name is ${this.name} and I am a ${this.species}.`);
    }

    protected getAge(): number {
        return this.age;
    }

    private getSpecies(): string {
        return this.species;
    }
}

class Dog extends Animal1 {
    breed: string;

    constructor(name: string, age: number, species: string, breed: string) {
        super(name, age, species);
        this.breed = breed;
    }

    public bark(): void {
        console.log("Woof!");
    }
}

// Create instances of Animal, Dog, and Cat classes
const animal1 = new Animal1("Unknown", 5, "unknown");
const animal2 = new Animal2("Unknown", 5, "unknown");
const dog = new Dog("Fido", 3, "dog", "corgy");


// Define a class with static fields and methods
class Circle {
    static pi: number = 3.14;
    pi = 3;

    static calculateArea(radius: number) {
        return this.pi * radius * radius;
    }
}

console.log(Circle.pi); // returns 3.14
console.log(Circle.calculateArea(5)); // returns 78.5

let circleObj = new Circle();
console.log(circleObj.pi); // returns 3