(function () {
    console.log("Стартиране на Propagation Demo...");

    const outer = document.getElementById('outer');
    const middle = document.getElementById('middle');
    const inner = document.getElementById('inner');

    if (!outer || !middle || !inner) {
        console.error("Липсващ елемент!");
        return;
    }

    [outer, middle, inner].forEach(el => {
        el.style.transition = "background-color 0.8s ease";
    });

    function logEvent(phase, elementId, color, delay = 0) {
        const element = document.getElementById(elementId);
        if (!element) return;

        setTimeout(() => {
            const label = phase === 'capture' ? 'CAPTURING' : 'BUBBLING';
            console.log(`${label} → ${elementId}`);
            element.style.backgroundColor = color;
        }, delay);
    }

    function resetColors(delay = 6000) {
        setTimeout(() => {
            [outer, middle, inner].forEach(el => {
                el.style.backgroundColor = "";
            });
        }, delay);
    }

    // CAPTURING (outer → inner) ===
    outer.addEventListener("click", (e) => {
        logEvent("capture", "outer", "red", 0);
    }, true);

    middle.addEventListener("click", (e) => {
        logEvent("capture", "middle", "red", 1000);
    }, true);

    inner.addEventListener("click", (e) => {
        logEvent("capture", "inner", "red", 2000);
    }, true);

    // BUBBLING (inner → outer) ===
    inner.addEventListener("click", (e) => {
        logEvent("bubble", "inner", "yellow", 3000);
    }, false);

    middle.addEventListener("click", (e) => {
        logEvent("bubble", "middle", "yellow", 4000);

        // Спиране на bubbling към outer:
        //e.stopPropagation();
    }, false);

    outer.addEventListener("click", (e) => {
        logEvent("bubble", "outer", "yellow", 5000);
        resetColors();
    }, false);

    console.log("Кликнете бутона '#inner' и гледайте ефекта.");
})();
