// Тук кодът е за пример, не е предвиден да бъде пускан да работи, особено като е в един файл

const makeCounter = function () {
    let privateCounter = 0;
    function changeBy(val) {
      privateCounter += val;
    }
    return {
      increment() {
        changeBy(1);
      },
  
      decrement() {
        changeBy(-1);
      },
  
      value() {
        return privateCounter;
      },
    };
  };
  
  const counter1 = makeCounter();
  const counter2 = makeCounter();
  
  console.log(counter1.value()); // 0
  
  counter1.increment();
  counter1.increment();
  console.log(counter1.value()); // 2
  
  counter1.decrement();
  console.log(counter1.value()); // 1
  console.log(counter2.value()); // 0
  
//  --------------------------------------------------------------------
  
  // global scope
  const e = 10;
  function sum(a) {
    return function sum2(b) {
      return function sum3(c) {
        // outer functions scope
        return function sum4(d) {
          // local scope
          return a + b + c + d + e;
        };
      };
    };
  }
  
  const sum2 = sum(1);
  const sum3 = sum2(2);
  const sum4 = sum3(3);
  const result = sum4(4);
  console.log(result); // 20
  
//  --------------------------------------------------------------------
  
  function outer() {
    let getY;
    {
      const y = 6;
      getY = () => y;
    }
    console.log(typeof y); // undefined
    console.log(getY()); // 6
  }
  
  outer();
  
//  --------------------------------------------------------------------
  // Тук ще работи ако всичко е в отделни файлове  

  // myModule.js
  export let x = 1;
  export const setX = (val) => {
    x = val;
  };
  
  // closureCreator.js
  import { x } from "./myModule.js";
  
  export const getX = () => x;
  
  // Close over an imported live binding
  import { getX } from "./closureCreator.js";
  import { setX } from "./myModule.js";
  
  console.log(getX()); // 1
  setX(2);
  console.log(getX()); // 2
  
//  --------------------------------------------------------------------
  
  function showHelp(help) {
    document.getElementById("help").textContent = help;
  }
  
  function setupHelp() {
    var helpText = [
      { id: "email", help: "Your email address" },
      { id: "name", help: "Your full name" },
      { id: "age", help: "Your age (you must be over 16)" },
    ];
  
    for (var i = 0; i < helpText.length; i++) {
      // Culprit is the use of `var` on this line
      var item = helpText[i];
      document.getElementById(item.id).onfocus = function () {
        showHelp(item.help);
      };
    }
  }
  
  setupHelp();
  
  // fixed with callback
  function showHelp(help) {
    document.getElementById("help").textContent = help;
  }
  
  function makeHelpCallback(help) {
    return function () {
      showHelp(help);
    };
  }
  
  function setupHelp() {
    var helpText = [
      { id: "email", help: "Your email address" },
      { id: "name", help: "Your full name" },
      { id: "age", help: "Your age (you must be over 16)" },
    ];
  
    for (var i = 0; i < helpText.length; i++) {
      var item = helpText[i];
      document.getElementById(item.id).onfocus = makeHelpCallback(item.help);
    }
  }
  
  setupHelp();
  
//  --------------------------------------------------------------------
  
  const module = (function() {
    const privateVar = "private";
    return {
      getVar: function() {
        return privateVar;
      }
    };
  })();
  console.log(module.getVar()); // Извежда "private"
  // console.log(module.privateVar); // грeшka: "privateVar" He е достьпно
  
//  --------------------------------------------------------------------
  
  
  const functions = [];
  for (var i = 0; i < 3; i++) {
    functions.push(() => console.log(i));
  }
  functions[0](); // Извежда 3
  functions[1](); // Извежда 3
  functions[2](); // Извежда 3
  
  // с let
  const fixedFunctions = [];
  for (let i = 0; i < 3; i++) {
    fixedFunctions.push(() => console.log(i));
  }
  fixedFunctions[0](); // Извежда 0
  fixedFunctions[1](); // Извежда 1
  fixedFunctions[2](); // Извежда 2
  
  // с IIFE
  const fixedFunctionsIIFE = [];
  for (let i = 0; i < 3; i++) {
    (function () {
      fixedFunctionIIFE.push(() => console.log(index));}
    )();
  }
  fixedFunctions[0](); // Извежда 0
  fixedFunctions[1](); // Извежда 1
  fixedFunctions[2](); // Извежда 2