function fetchDataWithErrors(url, callback, errorCallback) {
    const success = Math.random() >= 0.5; // Simulating random success/failure

    setTimeout(() => {
        if (success) {
            const data = { name: "Jane Doe", age: 25 };
            callback(data);
        } else {
            const error = "Failed to fetch data from the server";
            errorCallback(error);
        }
    }, 2000); // Simulating a 2-second delay
}

function displayDataWithErrors(data) {
    console.log(`Name: ${data.name}, Age: ${data.age}`);
}

function handleErrors(error) {
    console.error(`Error: ${error}`);
}

fetchDataWithErrors("https://api.example.com/data", displayDataWithErrors, handleErrors);
