// SEND
webSocket.send("Hello, WebSocket!");

webSocket.send(JSON.stringify({
  command: "subscribe",
  channel: "market_data",
  symbols: ["BTCUSDT"]
}));

// CLOSE
webSocket.close();

webSocket.close(1000, "Closure with reason");

// EVENT LISTENERS - Слушатели на събития
webSocket.onopen = function() { console.log("First handler"); };
webSocket.onopen = function() { console.log("Second handler"); }; // Заменя първия и само "Second handler" ще бъде изведен

webSocket.addEventListener('open', function() { console.log("First handler"); });
webSocket.addEventListener('open', function() { console.log("Second handler"); }); // Ще се изведат и "First handler" и "Second handler"

// EVENT HANDLERS - Обработчици на събития
webSocket.onopen = function(event) { // Вика се когато е установена връзката
    console.log("Connection established!");
};

webSocket.onmessage = function(event) { // Вика се когато получим съобщение от сървъра
    const data = JSON.parse(event.data);
    console.log("Received data:", data);
};

webSocket.onclose = function(event) { // Вика се когато връзката е затворена
    console.log("Connection closed:", event.code, event.reason);
};

webSocket.onerror = function(event) { // Вика се при грешка
    console.error("WebSocket error:", event);
};