const CRYPTO_SYMBOLS = [
    'btcusdt',  // Bitcoin
    'ethusdt',  // Ethereum
    'dogeusdt', // Dogecoin
    'xrpusdt',  // Ripple
    'adausdt',  // Cardano
    'solusdt'   // Solana
];

let webSocket = null;

function connectToWebSocket() {
    // Create WebSocket URL from CRYPTO_SYMBOLS
    const streams = CRYPTO_SYMBOLS.map(s => `${s}@ticker`).join('/');
    const wsUrl = `wss://stream.binance.com:9443/ws/${streams}`;
    
    // Create websocket connection
    webSocket = new WebSocket(wsUrl);
    
    // Event: Connection opened
    webSocket.onopen = function() {
        console.log('WebSocket connection established');
        document.dispatchEvent(new Event('ws-connected'));
    };
    
    // Event: Message received
    webSocket.onmessage = function(event) {
        const data = JSON.parse(event.data);
        document.dispatchEvent(new CustomEvent('ws-message', { 
            detail: data 
        }));
    };
    
    // Event: Connection closed
    webSocket.onclose = function() {
        console.log('WebSocket connection closed');
        document.dispatchEvent(new Event('ws-disconnected'));
    };
    
    // Event: Error occurred
    webSocket.onerror = function(error) {
        console.error('WebSocket error:', error);
    };
}

// Disconnect from WebSocket
function disconnectFromWebSocket() {
    if (webSocket) {
        webSocket.close();
        webSocket = null;
    }
}

// Get cryptocurrency symbols
function getCryptoSymbols() {
    return CRYPTO_SYMBOLS;
}