import { client } from './client';
import {
    GetRepoInfoDocument,
    GetRepoInfoQuery,
    GetRepoInfoQueryVariables,
} from './generated/graphql';

async function main(): Promise<void> {
    const variables: GetRepoInfoQueryVariables = {
        owner: 'StoyanTinchev',
        name: 'webtech-doodle',
    };

    try {
        const data: GetRepoInfoQuery = await client.request<
            GetRepoInfoQuery,
            GetRepoInfoQueryVariables
        >(GetRepoInfoDocument, variables);

        console.log(data.repository);
    } catch (error: any) {
        if (error.response?.status === 401) {
            console.log('Unauthorized – токенът липсва или няма достатъчни права');
        } else {
            console.log({ err: error?.message ?? error }, 'Грешка при GraphQL заявка');
        }
        process.exit(1);
    }
}

main();
