const openai = "sk-proj-твоят ключ";


localStorage.setItem("client_id", 'твоят ключ');
localStorage.setItem("client_secret", 'твоят ключ');


var redirect_uri = "http://127.0.0.1:5500/index.html"; 
var client_id = ""; 
var client_secret = "";
var access_token = null;
var refresh_token = null;
var currentPlaylist = "";
var radioButtons = [];


function onPageLoad(){
    client_id = localStorage.getItem("client_id");
    client_secret = localStorage.getItem("client_secret");
    if ( window.location.search.length > 0 ){
        handleRedirect();
    }
    else{
        access_token = localStorage.getItem("access_token");
        if ( access_token == null ){
            // we don't have an access token so present token section
            document.getElementById("tokenSection").style.display = 'block';  
        }
        else {
            // we have an access token so present device section
            document.getElementById("deviceSection").style.display = 'block';  
            refreshDevices();
            refreshPlaylists();
            currentlyPlaying();
        }
    }
    refreshRadioButtons();
}

function handleRedirect(){
    let code = getCode();
    fetchAccessToken( code );
    window.history.pushState("", "", redirect_uri); // remove param from url
}

function getCode(){
    let code = null;
    const queryString = window.location.search;
    if ( queryString.length > 0 ){
        const urlParams = new URLSearchParams(queryString);
        code = urlParams.get('code')
    }
    return code;
}

function requestAuthorization(){
    let url = "https://accounts.spotify.com/authorize";
    url += "?client_id=" + client_id;
    url += "&response_type=code";
    url += "&redirect_uri=" + encodeURI(redirect_uri);
    url += "&show_dialog=true";
    url += "&scope=user-read-private user-read-email user-modify-playback-state user-read-playback-position user-library-read streaming user-read-playback-state user-read-recently-played  playlist-modify-public"; //playlist-read-private
    window.location.href = url; 
}

function fetchAccessToken( code ){
    let body = "grant_type=authorization_code";
    body += "&code=" + code; 
    body += "&redirect_uri=" + encodeURI(redirect_uri);
    body += "&client_id=" + client_id;
    body += "&client_secret=" + client_secret;
    callAuthorizationApi(body);
}

function refreshAccessToken(){
    refresh_token = localStorage.getItem("refresh_token");
    let body = "grant_type=refresh_token";
    body += "&refresh_token=" + refresh_token;
    body += "&client_id=" + client_id;
    callAuthorizationApi(body);
}

function callAuthorizationApi(body){
    let xhr = new XMLHttpRequest();
    xhr.open("POST", "https://accounts.spotify.com/api/token", true);
    xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
    xhr.setRequestHeader('Authorization', 'Basic ' + btoa(client_id + ":" + client_secret));
    xhr.send(body);
    xhr.onload = handleAuthorizationResponse;
}

function handleAuthorizationResponse(){
    if ( this.status == 200 ){
        var data = JSON.parse(this.responseText);
        console.log(data);
        var data = JSON.parse(this.responseText);
        if ( data.access_token != undefined ){
            access_token = data.access_token;
            localStorage.setItem("access_token", access_token);
        }
        if ( data.refresh_token  != undefined ){
            refresh_token = data.refresh_token;
            localStorage.setItem("refresh_token", refresh_token);
        }
        onPageLoad();
    }
    else {
        console.log(this.responseText);
        alert(this.responseText);
    }
}

function refreshDevices(){
    fetch("https://api.spotify.com/v1/me/player/devices", {
        method: 'GET',
        headers: {
          'Content-Type': 'application/json',
          'Authorization': 'Bearer ' + access_token
        },
      })
      .then(res => {
        if(res.status == 200){
            var data = res.json().then(info => {
                console.log(info);
                removeAllItems("devices");
                info.devices.forEach(item =>
                {
                    let node = document.createElement("option");
                    node.value = item.id;
                    node.innerHTML = item.name;
                    document.getElementById("devices").appendChild(node)
                }
            );
            }) 
        }
        else if(res.status == 401){
            refreshAccessToken()
        }

      });
}

function callApi(method, url, body, callback){
    let xhr = new XMLHttpRequest();
    xhr.open(method, url, true);
    xhr.setRequestHeader('Content-Type', 'application/json');
    xhr.setRequestHeader('Authorization', 'Bearer ' + access_token);
    xhr.send(body);
    xhr.onload = callback;
}

function refreshPlaylists(){
    fetch("https://api.spotify.com/v1/me/playlists", {
        method: 'GET',
        headers: {
          'Content-Type': 'application/json',
          'Authorization': 'Bearer ' + access_token
        },
      })
      .then(res => {
        if(res.status == 200){
            var data = res.json().then(info => {
                console.log(info);
                removeAllItems( "playlists" );
                info.items.forEach(item => addPlaylist(item));
                document.getElementById('playlists').value=currentPlaylist;
            })
        }
        else if( res.status == 401){
            refreshAccessToken()
        }
      })
}

function addPlaylist(item){
    let node = document.createElement("option");
    node.value = item.id;
    node.innerHTML = item.name + " (" + item.tracks.total + ")";
    document.getElementById("playlists").appendChild(node); 
}

function removeAllItems( elementId ){
    let node = document.getElementById(elementId);
    while (node.firstChild) {
        node.removeChild(node.firstChild);
    }
}

function play(){
    let playlist_id = document.getElementById("playlists").value;
    let trackindex = document.getElementById("tracks").value;
    let body = {};
    body.context_uri = "spotify:playlist:" + playlist_id;//
    body.offset = {};
    body.offset.position = trackindex.length > 0 ? Number(trackindex) : 0;
    body.offset.position_ms = 0;

    callApi( "PUT", "https://api.spotify.com/v1/me/player/play?device_id=" + deviceId(), JSON.stringify(body), handleApiResponse );
}

function shuffle(){
    callApi( "PUT", "https://api.spotify.com/v1/me/player/shuffle?state=true&device_id=" + deviceId(), null, handleApiResponse );
    play(); 
}

function pause(){
    callApi( "PUT", "https://api.spotify.com/v1/me/player/pause?device_id=" + deviceId(), null, handleApiResponse );
}

function next(){
    callApi( "POST", "https://api.spotify.com/v1/me/player/next?device_id=" + deviceId(), null, handleApiResponse );
}

function previous(){
    callApi( "POST", "https://api.spotify.com/v1/me/player/previous?device_id=" + deviceId(), null, handleApiResponse );
}

function transfer(){
    let body = {};
    body.device_ids = [];
    body.device_ids.push(deviceId())
    callApi( "PUT", "https://api.spotify.com/v1/me/player", JSON.stringify(body), handleApiResponse );
}

function handleApiResponse(){
    if ( this.status == 200){
        console.log(this.responseText);
        setTimeout(currentlyPlaying, 2000);
    }
    else if ( this.status == 204 ){
        setTimeout(currentlyPlaying, 2000);
    }
    else if ( this.status == 401 ){
        refreshAccessToken()
    }
    else {
        console.log(this.responseText);
        alert(this.responseText);
    }    
}

function deviceId(){
    return document.getElementById("devices").value;
}

function fetchTracks(){
    let playlist_id = document.getElementById("playlists").value;
    if ( playlist_id.length > 0 ){
        // url = "https://api.spotify.com/v1/playlists/{{PlaylistId}}/tracks".replace("{{PlaylistId}}", playlist_id);
        url = `https://api.spotify.com/v1/playlists/${playlist_id}/tracks`;
        callApi( "GET", url, null, handleTracksResponse );
    }
}

function handleTracksResponse(){
    if ( this.status == 200 ){
        var data = JSON.parse(this.responseText);
        console.log(data);
        removeAllItems( "tracks" );
        data.items.forEach( (item, index) => addTrack(item, index));
    }
    else if ( this.status == 401 ){
        refreshAccessToken()
    }
    else {
        console.log(this.responseText);
        alert(this.responseText);
    }
}

function addTrack(item, index){
    let node = document.createElement("option");
    node.value = index;
    node.innerHTML = item.track.name + " (" + item.track.artists[0].name + ")";
    document.getElementById("tracks").appendChild(node); 
}

function currentlyPlaying(){
    callApi( "GET", "https://api.spotify.com/v1/me/player?market=US", null, handleCurrentlyPlayingResponse );
}

function handleCurrentlyPlayingResponse(){
    if ( this.status == 200 ){
        var data = JSON.parse(this.responseText);
        console.log(data);
        if ( data.item != null ){
            document.getElementById("albumImage").src = data.item.album.images[0].url;
            document.getElementById("trackTitle").innerHTML = data.item.name;
            document.getElementById("trackArtist").innerHTML = data.item.artists[0].name;
        }


        if ( data.device != null ){
            // select device
            currentDevice = data.device.id;
            document.getElementById('devices').value=currentDevice;
        }

        if ( data.context != null ){
            // select playlist
            currentPlaylist = data.context.uri;
            currentPlaylist = currentPlaylist.substring( currentPlaylist.lastIndexOf(":") + 1,  currentPlaylist.length );
            document.getElementById('playlists').value=currentPlaylist;
        }
    }
    else if ( this.status == 204 ){

    }
    else if ( this.status == 401 ){
        refreshAccessToken()
    }
    else {
        console.log(this.responseText);
        alert(this.responseText);
    }
}

function saveNewRadioButton(){
    let item = {};
    item.deviceId = deviceId();
    item.playlistId = document.getElementById("playlists").value;
    radioButtons.push(item);
    localStorage.setItem("radio_button", JSON.stringify(radioButtons));
    refreshRadioButtons();
}

function refreshRadioButtons(){
    let data = localStorage.getItem("radio_button");
    if ( data != null){
        radioButtons = JSON.parse(data);
        if ( Array.isArray(radioButtons) ){
            removeAllItems("radioButtons");
            radioButtons.forEach( (item, index) => addRadioButton(item, index));
        }
    }
}

function onRadioButton( deviceId, playlistId ){
    let body = {};
    body.context_uri = "spotify:playlist:" + playlistId;
    body.offset = {};
    body.offset.position = 0;
    body.offset.position_ms = 0;
    callApi( "PUT", "https://api.spotify.com/v1/me/player/play?device_id=" + deviceId, JSON.stringify(body), handleApiResponse );
}

function addRadioButton(item, index){
    let node = document.createElement("button");
    node.className = "btn btn-primary m-2";
    node.innerText = index;
    node.onclick = function() { onRadioButton( item.deviceId, item.playlistId ) };
    document.getElementById("radioButtons").appendChild(node);
}


let playlistId = '';

function createPlaylist(){
    let playlistName = document.getElementById('playlistName').value;
        console.log(access_token);
        fetch("https://api.spotify.com/v1/users/lpgxekrn9uhpiqk1pxcl3rk3u/playlists", {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
          'Authorization': 'Bearer ' + access_token
        },
        body: JSON.stringify({
            name: `${playlistName}`
        })
      }).then(res => res.json()).then(data => {
        playlistId = data.id;
      })

}



async function generateCover(){
    let imagePrompt = document.getElementById('playlistCover').value;
    fetch('https://api.openai.com/v1/images/generations', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'Authorization': `Bearer ${openai}`
        },
        body: JSON.stringify({
            "model": "dall-e-3",
            "prompt": `${imagePrompt} \n Don't include any text in the image.`,
            "n": 1,
            "size": "1024x1024"
        })
    }).then(res => res.json()).then(res => {
        console.log(res.data[0].url);
        console.log(document.getElementById('generatedCover').src)
        document.getElementById('generatedCover').src = res.data[0].url;
    })
}

let songIds = [];

async function askOpenAi() {
    let prompt = document.getElementById('playlistPrompt').value;
    fetch('https://api.openai.com/v1/chat/completions', {
        method: 'POST',
        headers: {
            'Authorization' : `Bearer ${openai}`,
            'Content-Type': 'application/json'
        },
        body: JSON.stringify({
            "messages": [
                {
                    "role": "system",
                    "content": "You are a helpful assistant."
                },
                {
                    "role": "user",
                    "content": `Give me playlist with ${prompt}. Answer only with song names. Give the answes in such format number. song name by artist name`
                }
            ],
            "model": "gpt-3.5-turbo"
        })

    })
    .then(res => res.json()).then(data => {
        console.log(data.choices[0].message.content);
    const lines = data.choices[0].message.content.split('\n').filter(Boolean);
    const songs = {};
    lines.forEach(line => {
        const [index, songInfo] = line.split('. ');
        const [songName, artist] = songInfo.split(' by ');

        const cleanSongName = songName.replace(/"/g, '');

        songs[cleanSongName] = artist;
    });
    console.log(songs);
    let playlistField = document.getElementById('playlist');
    // playlistField.innerHTML = '';
    for (const songName in songs) {
        if (songs.hasOwnProperty(songName)) {
            const artist = songs[songName];
            fetch(`https://api.spotify.com/v1/search?q=track%3A${songName}%20artist%3A${artist}&type=track&limit=1`, {
                method: "GET",
                headers: {
                Authorization: `Bearer ${access_token}`,
                }
            }).then(res => res.json()).then(res => {
                if(res.tracks.items.length > 0 && res.tracks.items[0].id != undefined && res.tracks.items[0].id != null){
                    songIds.push(res.tracks.items[0].id);
                    
                }
                
                let frame = document.createElement('iframe');
                frame.style="border-radius:12px";
                frame.src=`https://open.spotify.com/embed/track/${res.tracks.items[0].id}?utm_source=generator`
                frame.width="100%";
                frame.height="152";
                frame.frameBorder="0";
                frame.allowfullscreen="";
                frame.allow="autoplay; clipboard-write; encrypted-media; fullscreen; picture-in-picture";
                frame.loading="lazy";
                playlistField.appendChild(frame);

            });
        }
    }
    
    })
}

function addSongsToPlaylist(){
    let formatedIds = [];
    songIds.forEach(songId => {
        let uri = `spotify:track:${songId}`
        formatedIds.push(uri);
    })

    setTimeout(console.log(formatedIds) , 2000);

    setTimeout(     
    fetch(`https://api.spotify.com/v1/playlists/${playlistId}/tracks`, {
        method: 'POST',
        headers: {
            'Authorization':`Bearer ` + access_token,
            'Content-Type':'application/json'
        },
        body: JSON.stringify({
            "uris": formatedIds
    })
}), 3000)

    setTimeout(() => {
        let wrapperEl = document.getElementById('createdPlaylist');
        let frame = document.createElement('iframe');
        frame.src=`https://open.spotify.com/embed/playlist/${playlistId}?utm_source=generator`;
        frame.width="100%";
        frame.height="152";
        frame.frameBorder="0";
        frame.allowfullscreen="";
        frame.allow="autoplay; clipboard-write; encrypted-media; fullscreen; picture-in-picture";
        frame.loading="lazy";
        frame.style="border-radius:12px";
        wrapperEl.appendChild(frame);
    }          
        , 6000)


}