async function fetchDataWithAsync(url) {
    const success = Math.random() >= 0.5; // Simulating random success/failure

    return new Promise((resolve, reject) => {
        setTimeout(() => {
            if (success) {
                const data = { name: "Jack Smith", age: 35 };
                resolve(data);
            } else {
                const error = "Failed to fetch data from the server";
                reject(error);
            }
        }, 2000); 
    });
}

async function fetchData() {
    try {
        const data = await fetchDataWithAsync("https://api.example.com/data");
        console.log(`Name: ${data.name}, Age: ${data.age}`);
    } catch (error) {
        console.error(`Error: ${error}`);
    }
}

fetchData();
