function fetchDataWithPromise(url) {
    return new Promise((resolve, reject) => {
        const success = Math.random() >= 0.5;

        setTimeout(() => {
            if (success) {
                const data = { name: "Jack Smith", age: 35 };
                resolve(data);
            } else {
                const error = "Failed to fetch data from the server";
                reject(error);
            }
        }, 2000); // Simulating a 2-second delay
    });
}

// Fetching data using promises and handling the result
fetchDataWithPromise("https://api.example.com/data")
    .then((data) => {
        console.log(`Name: ${data.name}, Age: ${data.age}`);
    })
    .catch((error) => {
        console.error(`Error: ${error}`);
    });