let currentUsername = "";
let page = 1;

const nextBtn = document.getElementById("next-btn");
const createBtn = document.getElementById("create-btn");
const deleteBtn = document.getElementById("delete-btn");

const list = document.getElementById("repo-list");
const pageNum = document.getElementById("page-num");

async function getGitHubUser() {
  const username = document.getElementById("username").value;
  currentUsername = username;

  const res = await fetch(`/api/user/${username}`);
  const data = await res.json();

  if (data.message === "Not Found") {
    document.getElementById("result").innerText = "User not found.";
  } else {
    document.getElementById("result").innerHTML = `
      <img src="${data.avatar_url}" width="100" />
      <h2>${data.name || "No name"}</h2>
      <p><strong>Username:</strong> ${data.login}</p>
      <p><strong>Public Repos:</strong> ${data.public_repos}</p>
      <p><strong>Bio:</strong> ${data.bio || "No bio"}</p>
    `;
  }
  page = 1;
  await loadRepos();
}

async function loadRepos() {
  const res = await fetch(`/api/repos/${currentUsername}?page=${page}`);
  const data = await res.json();
  list.innerHTML = "";
  if (data.length === 0) {
    list.innerHTML = "<li>No more repos.</li>";
    nextBtn.disabled = true;
  } else {
    data.forEach((repo) => {
      const li = document.createElement("li");
      li.textContent = repo.name;
      list.appendChild(li);
    });
    nextBtn.disabled = false;
  }
  pageNum.textContent = page;
}

nextBtn.addEventListener("click", () => {
  page++;
  loadRepos();
});

document.getElementById("create-btn").addEventListener("click", async () => {
  const repoName = document.getElementById("create-repo").value;

  const res = await fetch("/create", {
    method: "POST",
    headers: {
      "Content-Type": "application/json",
    },
    body: JSON.stringify({ name: repoName }),
  });

  const data = await res.json();
  alert(data.message || JSON.stringify(data));
  getGitHubUser();
});

document.getElementById("delete-btn").addEventListener("click", async () => {
  const repoName = document.getElementById("delete-repo").value;

  const res = await fetch("/delete", {
    method: "DELETE",
    headers: {
      "Content-Type": "application/json",
    },
    body: JSON.stringify({ name: repoName }),
  });

  const data = await res.json();
  alert(data.message || JSON.stringify(data));
  getGitHubUser();
});
