require('dotenv').config()  // зареждаме .env ПРЕДИ всичко
/** @type {import('@graphql-codegen/cli').CodegenConfig} */
module.exports = {
    schema: [
        {
            'https://api.github.com/graphql': {
                headers: {
                    Authorization: `Bearer ${process.env.GITHUB_TOKEN}`,
                    'User-Agent': 'my-company-graphql-client',
                },
            },
        },
    ],
    documents: 'src/queries.ts',
    generates: {
        'src/generated/graphql.ts': {
            plugins: [
                'typescript',
                'typescript-operations',
                'typescript-graphql-request',
            ],
        },
    },
};
