import dotenv from 'dotenv';
import { GraphQLClient } from 'graphql-request';
import { cleanEnv, str } from 'envalid';

dotenv.config();

const env = cleanEnv(process.env, {
    GITHUB_TOKEN: str(),
});

export const client = new GraphQLClient('https://api.github.com/graphql', {
    headers: {
        Authorization: `Bearer ${env.GITHUB_TOKEN}`,
        'User-Agent': 'my-company-graphql-client',
    },
});
