import dotenv from "dotenv";
dotenv.config();
import express from "express";
import fetch from "node-fetch";
import path from "path";

const app = express();
const PORT = 3000;

const headers = {
  Authorization: `Bearer ${process.env.GITHUB_TOKEN}`,
  Accept: "application/vnd.github+json",
};

app.use(express.static("public"));
app.use(express.json());
app.get("/api/user/:username", async (req, res) => {
  const username = req.params.username;
  const userRes = await fetch(`https://api.github.com/users/${username}`, {
    headers,
  });
  const userData = await userRes.json();
  res.json(userData);
});

app.get("/api/repos/:username", async (req, res) => {
  const { username } = req.params;
  const { page = 1 } = req.query;

  try {
    const githubRes = await fetch(
      `https://api.github.com/users/${username}/repos?page=${page}&per_page=2`,
      {
        headers: {
          Authorization: `Bearer ${process.env.GITHUB_TOKEN}`,
          Accept: "application/vnd.github+json",
        },
      }
    );

    if (!githubRes.ok) {
      const errorData = await githubRes.json();
      return res.status(githubRes.status).json({ error: errorData.message });
    }

    const data = await githubRes.json();
    res.json(data);
  } catch (err) {
    console.error("Failed to fetch repos:", err);
    res.status(500).json({ error: "Server error" });
  }
});

let tokenUsername = "";
async function getTokenUsername() {
  const res = await fetch("https://api.github.com/user", { headers });
  const data = await res.json();
  tokenUsername = data.login;
}
await getTokenUsername();

app.post("/create", async (req, res) => {
  const { name, username } = req.body;
  const response = await fetch("https://api.github.com/user/repos", {
    method: "POST",
    headers,
    body: JSON.stringify({
      name: name,
      description: "Create test demo",
      private: false,
    }),
  });

  const data = await response.json();
  if (!response.ok) {
    return res.status(response.status).json(data);
  }
  res.json({
    message: `Repo "${name}" created successfully.`,
  });
});

app.delete("/delete", async (req, res) => {
  const { name } = req.body;
  const response = await fetch(
    `https://api.github.com/repos/${tokenUsername}/${name}`,
    {
      method: "DELETE",
      headers,
    }
  );

  if (response.status === 204) {
    res.json({
      message: `Repo "${name} deleted succesfully.`,
    });
  } else {
    const data = await response.json();
    res.status(response.status).json(data);
  }
});

app.listen(PORT, () => {
  console.log(`Server running at http://localhost:${PORT}`);
});
