package bg.sofia.uni.fmi;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.webkit.WebSettings;
import android.webkit.WebView;

public class NewsActivity extends Activity {
	
	private static final Intent NEWS_SERVICE_INTENT = new Intent("bg.sofia.uni.fmi.NEWS_UPDATE_SERVICE");
	private WebView mNewsView;
	private NewsUpdateService mService;
	
	ServiceConnection mConnection = new ServiceConnection() {
		
		@Override
		public void onServiceDisconnected(ComponentName name) {
			mService = null;
		}
		
		@Override
		public void onServiceConnected(ComponentName name, IBinder service) {
			mService = ((NewsUpdateServiceBinder)service).getService();
			initContent(mService.getFmiNews());
			mService.scheduleUpdate(mHandler, 5000);
		}
	};
	
	private Handler mHandler = new Handler() {
		
		public void handleMessage(android.os.Message msg) {
			if(msg.what == NewsUpdateService.UPDATE_MESSAGE_ID) {
				initContent((String)msg.obj);
				mService.scheduleUpdate(this, 5000);
			}
		}
		
	};
	
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        
        
        mNewsView = (WebView)findViewById(R.id.newsView);
		mNewsView.setFocusable(false);

		// enable JavaScript
		WebSettings webSettings = mNewsView.getSettings();
		webSettings.setJavaScriptEnabled(true);
		bindService(NEWS_SERVICE_INTENT, mConnection, Context.BIND_AUTO_CREATE);
    }
    
    @Override
    protected void onStart() {
    	super.onStart();
    	bindService(NEWS_SERVICE_INTENT, mConnection, Context.BIND_AUTO_CREATE);
    }
    
    @Override
    protected void onPause() {
    	super.onPause();
    	unbindService(mConnection);
    }
    
    void initContent(String htmlData) {
    	mNewsView.loadDataWithBaseURL("fake!!!", htmlData, "text/html", "UTF-8", null);
    }
}