package bg.sofia.uni.fmi;

import java.io.IOException;

import javax.xml.parsers.FactoryConfigurationError;

import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.params.ClientPNames;
import org.apache.http.client.params.CookiePolicy;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;

import android.app.Service;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.util.Log;

public class NewsUpdateService extends Service {

	private static final String FMI_NEWS_URL = "http://www.fmi.uni-sofia.bg/news";
	public static final int UPDATE_MESSAGE_ID = 13;
	
	@Override
	public IBinder onBind(Intent intent) {
		return new NewsUpdateServiceBinder(this);
	}
	
	@Override
	public void onCreate() {
		super.onCreate();
	}
	
	public String getFmiNews() {
		// Do an HTTP post
		HttpGet get = new HttpGet(FMI_NEWS_URL);
		
		DefaultHttpClient httpclient = new DefaultHttpClient();
		
		httpclient.getParams().setParameter(ClientPNames.COOKIE_POLICY,
				CookiePolicy.RFC_2965);
		
		// Override the default policy for this request
		get.getParams().setParameter(ClientPNames.COOKIE_POLICY,
				CookiePolicy.BROWSER_COMPATIBILITY);
		
		ResponseHandler<String> responseHandler = new BasicResponseHandler();
		String responseBody = null;
		try {
			responseBody = httpclient.execute(get, responseHandler);
		} catch (ClientProtocolException e) {
			throw new RuntimeException(e);
		} catch (IOException e) {
			throw new RuntimeException(e);
		} catch (FactoryConfigurationError e) {
			throw new RuntimeException(e);
		}
		
		httpclient.getConnectionManager().shutdown();
		
		responseBody = responseBody.substring(
				responseBody.indexOf("<h1 class=\"documentFirstHeading\">"), 
							responseBody.indexOf("<div class=\"listingBar\">"));
		
		return responseBody;
	
	}
	
	public void scheduleUpdate(final Handler handler, final long millis) {
		new Thread() {
			@Override
			public void run() {
				super.run();
				String updatedData = getFmiNews();
				Message data = new Message();
				data.obj = updatedData;
				data.what = UPDATE_MESSAGE_ID;
				handler.sendMessageDelayed(data, millis);
				Log.i("TAG", "Updated");
			}
		}.start();
	}
	
	

}
