package com.fmi.androidcourse;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;

public class MainActivity extends Activity {
	
	private BroadcastReceiver mReceiver;
	private OnClickListener mOnClickListener = new OnClickListener() {

		@Override
		public void onClick(View v) {
			Intent intent = new Intent(Constants.ACTION_SHOW_DIALOG);
			sendBroadcast(intent);
		}
	};
	
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        
        Button button = (Button) findViewById(R.id.button_broadcast_one);
        button.setOnClickListener(mOnClickListener);
    }

	@Override
	protected void onResume() {

		super.onResume();
		
		IntentFilter filter = new IntentFilter();
		filter.addAction(Constants.ACTION_SHOW_DIALOG);
		mReceiver = new DialogReceiver();
		registerReceiver(mReceiver, filter);
	}

	@Override
	protected void onPause() {
	
		unregisterReceiver(mReceiver);
		
		super.onPause();
	}
}