package com.fmi.androidcourse;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.EditText;

public class MainActivity extends Activity {
    
	private static final String COM_FMI_ANDROIDCOURSE_SIGN_UP = "com.fmi.androidcourse.SIGN_UP";

	private static final int SIGN_UP_CODE = 0;
	
	private OnClickListener mRegisterClickListener = new OnClickListener() {
		
		public void onClick(View view) {			
			Intent i = new Intent(COM_FMI_ANDROIDCOURSE_SIGN_UP);
			String username = ((EditText)findViewById(R.id.username)).getText().toString();
			i.putExtra("com.fmi.androidcourse.username", username);
			startActivityForResult(i, SIGN_UP_CODE);
		}
	};
	
	private OnClickListener mStartActivityClickListener = new OnClickListener() {

		@Override
		public void onClick(View view) {
			Uri uri = Uri.parse("tel:35988");
			//Uri uri = Uri.parse("http://google.com");
			//Uri uri = Uri.parse("content://contacts/people");
			Intent intent = new Intent(Intent.ACTION_VIEW, uri);
			startActivity(intent);
		}
	};
	
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        
        setContentView(R.layout.main);
        Button buttonGo = (Button) findViewById(R.id.btn_go);
        buttonGo.setOnClickListener(mRegisterClickListener);
        
        Button buttonStartAvtivity = (Button) findViewById(R.id.btn_start_activity);
        buttonStartAvtivity.setOnClickListener(mStartActivityClickListener);
    }

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {
		super.onActivityResult(requestCode, resultCode, data);
		
		switch (requestCode) {
		case SIGN_UP_CODE:
			if (resultCode == RESULT_OK) {
				String selectedUsername = data.getExtras().getString("com.fmi.androidcourse.selectedUsername");
				
				AlertDialog.Builder builder = new AlertDialog.Builder(this);
				builder.setMessage("Username: " + selectedUsername + " created successfully!");
				builder.setPositiveButton("OK", null);
				builder.setCancelable(true);
				
				AlertDialog dialog = builder.create();
				dialog.show();
			}
			break;
		}
	}
}