#include <iostream>
#include <list>

// Iterative Merge Sort for lists with O(1) memory
void mergeSort(std::list<int>& l)
{
    size_t len = l.size();
    if(len < 2) return;

    for(size_t step = 1; step < len; step *= 2)
    {
        for(auto start = l.begin(); start != l.end();)
        {
            auto start2 = start, e = start;
            for(size_t i = 0; i < step; ++i)
            {
                if(start2 != l.end()) ++start2;
                if(e != l.end()) ++e;
                if(e != l.end()) ++e;
            }
            if(start2 == l.end())
                break;

            auto cur1 = start, cur2 = start2;
            while(cur1 != e && cur2 != e)
            {
                if(*cur1 <= *cur2)
                    ++cur1;
                else
                {
                    int temp = *cur2;
                    cur2 = l.erase(cur2);

                    l.insert(cur1, temp);
                }
            }
            start = e;
        }
    }
}

void stdListMergeSortDemo()
{
    std::list<int> l;
    l.push_back(54);
    l.push_back(37);
    l.push_back(87);
    l.push_back(36);
    l.push_back(11);
    l.push_back(75);
    l.push_back(66);
    l.push_back(12);
    l.push_back(9);
    l.push_back(58);
    l.push_back(45);
    l.push_back(31);
    l.push_back(20);
    l.push_back(14);
    l.push_back(34);
    l.push_back(79);
    l.push_back(40);
    l.push_back(50);
    l.push_back(96);
    l.push_back(100);

    for(auto i : l)
    {
        std::cout << i << " ";
    }
    std::cout << std::endl;

    mergeSort(l);

    for(auto i : l)
    {
        std::cout << i << " ";
    }
    std::cout << std::endl;
}

int main() 
{
    stdListMergeSortDemo();
    return 0;
}
