// Test program for BubbleSort

// Not to be run about midnight!

#include <stdio.h>
#include <stdlib.h>
#include <values.h>
#include <dos.h>

typedef int bool;

#define false 0
#define true  1

void swap(unsigned int * x, unsigned int * y) {
  int z = *x;
  *x = *y;
  *y = z;
}

void BubbleSort(unsigned int A[], unsigned int n) {
  bool swapped;
  do {
    swapped = false;
    for (int k = 1; k < n; k++) {
      if (A[k-1] > A[k]) {
	swap(&A[k-1], &A[k]);
	swapped = true;
      }
    }
  }
  while (swapped);
}

void InitArrayWithRandomValues(unsigned int A[], unsigned long int n) {
  for (unsigned long int k = 0; k < n; k++)
    A[k] = random(MAXINT);
}

unsigned long int GetCurrentTime() { // in hundredths of second
  struct time t;
  gettime(&t);
  return t.ti_hour * 360000 + t.ti_min * 6000 + t.ti_sec * 100 + t.ti_hund;
}

void TestAlgorithm() {
  unsigned int * A = (unsigned int *) malloc(30000L * sizeof(int));
  for (int cnt = 1; cnt <= 100; cnt++) { // cnt = number of experiments
    for (unsigned int k = 1; k <= 10; k++) {
      if (k > 1) printf("\t");
      unsigned long int n = 3000L * k; // n = actual array length
      InitArrayWithRandomValues(A,n);
      unsigned long int before = GetCurrentTime();
      BubbleSort(A,n);
      unsigned long int after = GetCurrentTime();
      unsigned long int TimeElapsed = after - before; // in centiseconds
      // Not to be run about midnight!
      printf("%u", TimeElapsed);
    }
    printf("\n");
  }
  free(A);
}

void main() {
  TestAlgorithm();
}