#include <iostream>
#include<cmath>
using namespace std;
const int size=5;
const int total_positions = pow(3,size);
char win[total_positions];

int pow3(int k)
{
    if (k==0)
        return 1;
    int s=pow3(k/2);
    if(k%2==1)
        return 3*s*s;
    return s*s;
}

char calculate(char win[], int i)
{
    if(win[i]!='N')
        return win[i];
    
    bool left=false, right=false;
    for(int s=0;s<size-1;s++)// T move:  *10* -> *01* 
    {
        if(i>=pow3(s+1))
        {
        int r=(i- pow3(s+1))%(pow3(s+2));
        if(r< pow3(s))
            {
                char p= calculate(win,i-pow3(s+1)+pow3(s));
                if(p=='0' || p=='L')
                    left=true;
            }
        }
    }
    
    for(int s=0;s<size-2;s++) //T jump:  *120* -> *021*
    {
        if(i>= pow3(s+2) +2*pow3(s+1))
        {
            int r= (i-pow3(s+2)-2*pow3(s+1))%(pow3(s+3));
            if(r< pow3(s))
            {
                char p=calculate(win, i-pow3(s+2)+pow3(s));
                if(p=='0' || p=='L')
                    left=true;
            }
        }
    }
    
    for(int s=0;s<size-1;s++) //R move:  *02* -> *20*
    {
        if(i>= 2*pow3(s))
        {
            int r=(i-2*pow3(s))%(pow3(s+2));
            if(r< pow3(s))
            {
                char q= calculate(win,i-2*pow3(s)+2*pow3(s+1));
                if(q=='0' || q=='R')
                    right=true;
            }
        }
    }
    
    for(int s=0;s<size-2;s++) // R jump:  *012* -> *210*
    {
        if(i>= pow3(s+1)+2*pow3(s))
        {
            int r=(i-pow3(s+1)-2*pow3(s))%(pow3(s+3));
            if(r< pow3(s))
            {
                char q=calculate(win, i+2*pow3(s+2)-2*pow3(s));
                if(q=='0' || q=='R')
                    right=true;
            }
        }
    }
    
    if(left)
    {
        if(right)
            return '|';
        else
            return 'L';
    }
    else
    {
        if(right)
            return 'R';
        else
            return '0';
    }
}

int main()
{  
  for(int i=0;i<total_positions;i++)
    win[i]='N';
  
  for(int i=0;i<total_positions;i++)
    win[i] = calculate(win, i);
    
  for(int i=0;i<total_positions;i++)
  {
      int j=i,arr[size];
      for(int s=0;s<size;s++)
      {
          arr[size-1-s]=j%3;
          j=j/3;
      }
      for(int s=0;s<size;s++)
      {
          if(arr[s]==0)
            cout<<"-";
          if(arr[s]==1)
            cout<<"T";
          if(arr[s]==2)
            cout<<"F";
      }
      cout<<" "<<win[i]<<endl;
  }
  return 0;
}
