﻿#include <cstdio>
#include <cstring>
#include <vector>
#include <algorithm>

using namespace std;

const int MAX_N = 52;
const int MAX_M = 52;
const int MAX_SEGMENTS = MAX_N * MAX_M;
const int MAX_CLAUSES = 2 * MAX_SEGMENTS;

int n, m;

char grid[MAX_N][MAX_M];

int start_col, start_row;

int cnt;
int row_id[MAX_N][MAX_M];
int col_id[MAX_N][MAX_M];
int first[MAX_SEGMENTS];
int last[MAX_SEGMENTS];

vector <int> g[MAX_SEGMENTS];

bool visited[MAX_SEGMENTS];
bool reach[MAX_SEGMENTS][MAX_SEGMENTS];

vector <int> G[MAX_CLAUSES];
vector <int> rG[MAX_CLAUSES];

int component[MAX_CLAUSES];
vector <int> order;

void read ()
{
    scanf ("%d%d", &n, &m);
    for (int i = 1; i <= n; i ++)
        scanf ("%s", grid[i] + 1);
}

void numerate ()
{
    cnt = 0;

    for (int i = 1; i <= n; i ++)
    {
        for (int j = 1; j <= m; j ++)
        {
            if (grid[i][j] == '#')
                continue;
            if ((j == 1) || (grid[i][j - 1] == '#'))
                first[++ cnt] = j;
            row_id[i][j] = cnt;
            last[cnt] = j;
        }

    }

    for (int i = 1; i <= m; i ++)
    {
        for (int j = 1; j <= n; j ++)
        {
            if (grid[j][i] == '#')
                continue;
            if ((j == 1) || (grid[j - 1][i] == '#'))
                first[++ cnt] = j;
            col_id[j][i] = cnt;
            last[cnt] = j;
        }
    }
}

bool isrowborder (int row, int j)
{
    return (first[row] == j || last[row] == j);
}

bool iscolborder (int col, int i)
{
    return (first[col] == i || last[col] == i);
}

void initialize ()
{
    for (int i = 1; i <= n; i ++)
        for (int j = 1; j <= m; j ++)
        {
            if (grid[i][j] == '#')
                continue;

            int col = col_id[i][j], row = row_id[i][j];

            if (grid[i][j] == 'O')
            {
                start_row = row;
                start_col = col;
            }

            if (iscolborder (col, i))
                g[col].push_back (row);
            if (isrowborder (row, j))
                g[row].push_back (col);
        }
}

void dfs (int x, int s)
{
    reach[s][x] = true;
    visited[x] = true;
    for (int to : g[x])
        if (!visited[to])
            dfs (to, s);
}

void transitive_closure ()
{
    for (int i = 1; i <= cnt; i ++)
    {
        memset (visited, 0, sizeof (visited));
        dfs (i, i);
    }
}

void add_edge (int _if, int _then)
{
    G[_if].push_back (_then);
    rG[_then].push_back (_if);
}

void constraints_2sat ()
{
    /**
    [1 ... cnt] clause is true
    [cnt + 1 ... 2 * cnt] clause is false
    **/


    /// reach the stars
    for (int i = 1; i <= n; i ++)
        for (int j = 1; j <= m; j ++)
            if (grid[i][j] == '*')
            {
                add_edge (cnt + row_id[i][j], col_id[i][j]);
                add_edge (cnt + col_id[i][j], row_id[i][j]);
            }

    /// begin at the O
    for (int i = 1; i <= cnt; i ++)
        if (!reach[start_col][i] && !reach[start_row][i])
            add_edge (i, cnt + i);

    /// be a path
    for (int i = 1; i <= cnt; i ++)
        for (int j = i + 1; j <= cnt; j ++)
            if (!reach[i][j] && !reach[j][i])
            {
                add_edge (i, cnt + j);
                add_edge (j, cnt + i);
            }
}

void forward_dfs (int x)
{
    visited[x] = true;
    for (int to : G[x])
        if (!visited[to])
            forward_dfs (to);
    order.push_back (x);
}

void reverse_dfs (int x, int c_id)
{
    visited[x] = true;
    component[x] = c_id;
    for (int to : rG[x])
        if (!visited[to])
            reverse_dfs (to, c_id);
}

void scc ()
{
    memset (visited, 0, sizeof (visited));
    for (int i = 1; i <= 2 * cnt; i ++)
        if (!visited[i])
            forward_dfs (i);
    reverse (order.begin (), order.end ());

    memset (visited, 0, sizeof (visited));
    int components_cnt = 0;
    for (int start : order)
        if (!visited[start])
            reverse_dfs (start, ++ components_cnt);
}

int main ()
{
    read (); /// Чете входните данни.
    numerate (); /// Номерира вертикалните и хоризонталните сегменти.
    initialize (); /// Строи ребрата между сегментите (разглеждани като върхове на граф).
    transitive_closure(); /// Намира за всеки сегмент от кои сегменти е достижим.
    constraints_2sat (); /// Построява граф за задачата 2-SAT.
    scc (); /// Намира компонентите на силна свързаност.

    /// Проверява дали има противоречие.
    for (int i = 1; i <= cnt; i ++)
        if (component[i] == component[cnt + i])
        {
            printf ("NO\n");
            return 0;
        }
    printf ("YES\n");

    return 0;
}
