#include<cstdio>
#include<algorithm>

using namespace std;

const int MAX_N = 300010;

int n;
int a[MAX_N];
int dp[MAX_N];
int sum[2][MAX_N];
int s[2];

int quadratic_dp ()
{
	dp[0] = (1 << 30);
	for (int i = 1; i * 2 <= (n + 1); i ++)
	{
		dp[i] = -(1 << 30); /// infinity
		for (int j = 0; j < i; j ++)
        	dp[i] = max (dp[i], min (dp[j], sum[1][i * 2 - 1] - sum[1][j * 2] - (sum[0][i * 2 - 1] - sum[0][j * 2])));
	}

	return dp[(n + 1) / 2];
}

bool check (int x)
{
    int sum = 0;
    for (int i = 1; i <= n; i += 2)
    {
        if (sum >= x)
            sum = max (sum - a[i - 1] + a[i], a[i]);
        else
            sum = sum - a[i - 1] + a[i];
    }
    return sum >= x;
}

int nlogn ()
{
    int l, r, mid;

    l = -1;
    r = s[1] + 1;
    while (r - l > 1)
    {
        mid = (l + r) >> 1;

        if (check (mid))
            l = mid;
        else
            r = mid;
    }

    return l;
}

int main ()
{
	scanf ("%d", &n);
	for (int i = 1; i <= n; i ++)
		scanf ("%d", &a[i]);

	for (int i = 1; i <= n; i ++)
		s[i & 1] += a[i];

	if (!(n & 1))
	{
		printf ("%d %d\n", max (s[0], s[1]), min (s[0], s[1]));
		return 0;
	}

	sum[0][0] = sum[1][0] = 0;
	for (int i = 1; i <= n; i ++)
	{
		sum[0][i] = sum[0][i - 1];
		sum[1][i] = sum[1][i - 1];
		sum[i & 1][i] += a[i];
	}

	int ans;

	///ans = quadratic_dp ();
	ans = nlogn ();

	printf ("%d %d\n", s[0] + ans, s[1] - ans);
	return 0;
}
