// Test program for Pollard_algorithm
#include <iostream>
#include <stdlib.h>
#include <cmath>
#include <time.h>
#include <chrono>
#include <cstdio>

unsigned long long gcd(unsigned long long a,unsigned long long b)
{
    unsigned long long remainder;
    while (b != 0)
    {
        remainder = a % b;
        a = b;
        b = remainder;
    }
    return a;
}

unsigned long long Pollard_algorithm(unsigned long long number)
{
    unsigned long long x_fixed = 2, cycle_size = 2, x = 2, factor = 1;
    while (factor == 1)
    {
        for (unsigned long long count=1; count <= cycle_size && factor <= 1; count++)
        {
            x = (x*x+1)%number;
            factor = gcd(abs(x - x_fixed), number);
        }
        cycle_size *= 2;
        x_fixed = x;
    }
    if(number%factor!=0)
    {
        return 1;
    }
    return factor;
}

void TestAlgorithm(unsigned long long* arr,int sz)
{
    unsigned long long use;
    for (int cnt = 0; cnt < sz; cnt++)
    {
        std::cout<<arr[cnt]<<'\t';
        auto start = std::chrono::system_clock::now();
        for(int i=0;i<100000;++i)
        {
            use=Pollard_algorithm(arr[cnt]);
        }
        auto end = std::chrono::system_clock::now();
        std::cout<<use<<'\t';
        auto elapsed = std::chrono::duration_cast<std::chrono::milliseconds>(end - start);
        std::cout<<(elapsed.count()/100000.0)<<'\n';
    }
}

int main()
{
    int sz;
    std::cin>>sz;
    unsigned long long arr[sz];
    for(int i = 0; i < sz; i++)
    {
        std::cin>>arr[i];
    }
    TestAlgorithm(arr,sz);
}
