﻿#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<stdbool.h>

struct sq{//координати на единично квадратче в таблицата
  int x,y;
};

bool equalPr(struct sq p,struct sq q){//operator==
  return q.x==p.x && q.y==p.y;
}

bool frame[2*(100+100)];//0 - бяло; 1 - черно
bool table[100][100];//0 - бяло; 1 - черно
int n,m;//n реда & m колони
int answer=0;
char draw;
const struct sq invalidCell={-1,-1};
struct sq endPoint[4];//потенциалните краища на пътеки
struct sq intersection[16];//пресечните точки
struct sq diagonal[8];//диагоналите
int nextpr[8]={0,1,-1,0,0,-1,1,0};//посоки

void printTable(){
  printf("\n");
  for(int i=0;i<n;i++){
    for(int j=0;j<m;j++){
      printf("%s",table[i][j]?"[]":" .");
    }
    printf("\n");
  }
  printf("\n");
}

struct sq linIndTabCoord(int l){//превръщаме линейния индекс на квадратчетата по дължината на рамката по часовниковата стрелка в координати от таблицата
  struct sq xy;
  int framelen=2*n+2*m-4;
  l=l%(framelen);
  if(l>=0&&l<m){
    xy.x=0;
    xy.y=l;
  }else if(l>=m&&l<n+m-2){
    xy.x=l-m+1;
    xy.y=m-1;
  }else if(l>=n+m-2&&l<=2*m+n-3){
    xy.x=n-1;
    xy.y=2*m+n-l-3;
  }else{
    xy.x=framelen-l;
    xy.y=0;
  }
  return xy;
}

void setDiagonals(int i,int j){
  int framelen=2*n+2*m-4;
  //това са диагоналите от ъглите на таблицата
  diagonal[0].x=0;
  diagonal[0].y=0;
  diagonal[1].x=n;
  diagonal[1].y=m;
  diagonal[4].x=0;
  diagonal[4].y=m;
  diagonal[5].x=n;
  diagonal[5].y=0;
  //останалите диагонали идват от местата на рамката, където се срещат двата цвята.
  diagonal[2].x=diagonal[6].x=(i>=1&&i<=m-1)?linIndTabCoord(i).x:(i>=m&&i<=m+n-2)?linIndTabCoord(i).x:(i>=m+n-1&&i<=2*m+n-3)?linIndTabCoord(i).x+1:linIndTabCoord(i).x+1;
  diagonal[2].y=diagonal[6].y=(i>=1&&i<=m-1)?linIndTabCoord(i).y:(i>=m&&i<=m+n-2)?linIndTabCoord(i).y+1:(i>=m+n-1&&i<=2*m+n-3)?linIndTabCoord(i).y+1:linIndTabCoord(i).y;
  diagonal[3].x=diagonal[7].x=((i+j)%framelen>=1&&(i+j)%framelen<=m-1)?linIndTabCoord((i+j)%framelen).x:((i+j)%framelen>=m&&(i+j)%framelen<=m+n-2)?linIndTabCoord((i+j)%framelen).x:((i+j)%framelen>=m+n-1&&(i+j)%framelen<=2*m+n-3)?linIndTabCoord((i+j)%framelen).x+1:linIndTabCoord((i+j)%framelen).x+1;
  diagonal[3].y=diagonal[7].y=((i+j)%framelen>=1&&(i+j)%framelen<=m-1)?linIndTabCoord((i+j)%framelen).y:((i+j)%framelen>=m&&(i+j)%framelen<=m+n-2)?linIndTabCoord((i+j)%framelen).y+1:((i+j)%framelen>=m+n-1&&(i+j)%framelen<=2*m+n-3)?linIndTabCoord((i+j)%framelen).y+1:linIndTabCoord((i+j)%framelen).y;
}

struct sq intersect(int i,int j){//пресичане на диагонали
  struct sq r;
  r.x=(diagonal[i].x+diagonal[j].x-diagonal[i].y+diagonal[j].y-1)/2;
  r.y=(-diagonal[i].x+diagonal[j].x+diagonal[i].y+diagonal[j].y-1)/2;
  if(!((diagonal[i].x+diagonal[j].x+diagonal[i].y+diagonal[j].y)%2&&r.x>=0&&r.x<=n-1&&r.y>=0&&r.y<=m-1)){
    r=invalidCell;
  }
  return r;
}

bool newIntrsc(struct sq set){
  for(int i=0;i<16;i++){
    if(equalPr(set,intersection[i])){
      return false;
    }
  }
  return true;
}

void setIntersections(){//пресичане на всички диагонали
    struct sq px;
  for(int i=0;i<4;i++){//diagonals[0..3] са в направление II-IV квадрант
    for(int j=4;j<8;j++){//diagonals[4..7] са в направление I-III квадрант
      px=intersect(i,j);
      if(newIntrsc(px)){
        intersection[4*i+j-4]=px;
      }
    }
  }
}

bool isEndPoint(int i, int j){
  struct sq d;
  d.x=i;
  d.y=j;
  return equalPr(d,endPoint[0]) || equalPr(d,endPoint[1]) || equalPr(d,endPoint[2]) || equalPr(d,endPoint[3]);
}

void color(int i,int j){//оцветява клетка според клетките в горния ред
  if(i==0){
    table[i][j]=frame[j];
  }else if(i==1){
    if(j==0||j==m-1){
      table[i][j]=table[i-1][j==0?1:m-2]^isEndPoint(i-1,j);
    }else{
      table[i][j]=table[i-1][j-1]^table[i-1][j]^table[i-1][j+1]^isEndPoint(i-1,j)^1;
    }
  }else if(j==0||j==m-1){
      table[i][j]=table[i-1][j]^table[i-2][j]^table[i-1][j==0?1:m-2]^isEndPoint(i-1,j)^1;
  }else{
    table[i][j]=table[i-1][j-1]^table[i-2][j]^table[i-1][j+1]^isEndPoint(i-1,j);
  }
}

void colorTable(){//оцветяваме по редове
  for(int i=0;i<n;i++){
    for(int j=0;j<m;j++){
      color(i,j);
    }
  }
}

bool testFrame(){//проверяваме дали оцветяването на рамката се е запазило след форсирането от първия ред
  struct sq cell;
  int framelen=2*n+2*m-4;
  for(int i=0;i<framelen;i++){
    cell=linIndTabCoord(i);
    if(frame[i]!=table[cell.x][cell.y]){
      return false;
    }
  }
  return true;
}

bool isInsideTable(struct sq in){
  return in.x>=0&&in.x<=n-1&&in.y>=0&&in.y<=m-1;
}

struct sq nextCell(struct sq cell,struct sq* prev){//следваща клетка в пътеката
  struct sq neigh[4];
  struct sq next;
  int val=0;
  for(int k=0;k<4;k++){
      neigh[k].x=cell.x+nextpr[2*k];
      neigh[k].y=cell.y+nextpr[2*k+1];
      if(!isInsideTable(neigh[k])||equalPr(neigh[k],*prev)||table[neigh[k].x][neigh[k].y]!=table[cell.x][cell.y]){
        neigh[k]=invalidCell;
      }else{
        next=neigh[k];
        val++;
      }
  }
  if(val==1){
    *prev=cell;
    return next;
  }else{
    return invalidCell;
  }
}

bool testPaths(){//проверяваме дали общата дължина на двете пътеки е равна на броя на клетките в цялата таблица
  int pathsLen=8;
  struct sq prev;
  for(int i=0;i<4;i++){
    prev=endPoint[i];
    for(struct sq cell=nextCell(prev,&prev);!isEndPoint(cell.x,cell.y)&&!equalPr(cell,invalidCell);cell=nextCell(cell,&prev)){
      pathsLen++;
    }
  }
  return pathsLen==2*n*m;
}

void testSolution(){//проверяваме дали полученото оцветяване води до решение
  if(testFrame() && testPaths()){
    answer++;
    if(draw=='y'){
      printf("Table %d:\n",answer);
      printTable();
    }
  }
}

void iterateEndPoints(int i,int j){//изпробваме всички възможни четворки пресечни точки
  memset(diagonal,-1,sizeof(diagonal));
  memset(intersection,-1,sizeof(intersection));
  setDiagonals(i,j);
  setIntersections();
  for(int i0=0;i0<13;i0++){
    if(!equalPr(intersection[i0],invalidCell)){
      for(int i1=i0+1;i1<14;i1++){
        if(!equalPr(intersection[i1],invalidCell)){
          for(int i2=i1+1;i2<15;i2++){
            if(!equalPr(intersection[i2],invalidCell)){
              for(int i3=i2+1;i3<16;i3++){
                if(!equalPr(intersection[i3],invalidCell)){
                  endPoint[0]=intersection[i0];
                  endPoint[1]=intersection[i1];
                  endPoint[2]=intersection[i2];
                  endPoint[3]=intersection[i3];
                  colorTable();
                  testSolution();
                }
              }
            }
          }
        }
      }
    }
  }
}

void iterateFrames(){//изпробваме всички възможни оцветявания на рамката
  int framelen=2*n+2*m-4;
  for(int firstBlack=0;firstBlack<framelen;firstBlack++){
    for(int numOfBlack=1;numOfBlack<framelen;numOfBlack++){
      memset(frame,0,framelen*sizeof(bool));
      for(int k=0;k<numOfBlack;k++){//оцветяваме черните клетки
        frame[(firstBlack+k)%framelen]=1;
      }
      iterateEndPoints(firstBlack,numOfBlack);
    }
  }
}

void solve(){
  printf("Table size:");
  scanf("%d %d",&n,&m);
  printf("Draw tables? (y/n)");
  scanf(" %c",&draw);
  iterateFrames();
  (draw=='y')?printf("\n"):printf("\n%d\n",answer);
}

int main(){
  solve();
  return 0;
}
