package component
{
	import flash.display.DisplayObject;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	
	import mx.core.UIComponent;
	import mx.events.FlexEvent;
	
	public class CustomComponent extends UIComponent
	{
		public static const ITEM_DIMENSION:Number = 50;
		public static const ITEM_PADDING:Number = 10;
		
		// <MODEL>
		
		private var colorsChanged:Boolean = false;
		private var _colors:Array;
		public function set colors(value:Array):void
		{
			_colors = value;
			colorsChanged = true;
			invalidateProperties();
		}
		public function get colors():Array
		{
			return _colors;
		}
		
		private var selectedColorChanged:Boolean = false;
		private var _selectedColor:Number;
		public function set selectedColor(value:Number):void
		{
			_selectedColor = value;
			selectedColorChanged = true;
			invalidateProperties();
		}
		public function get selectedColor():Number
		{
			return _selectedColor;
		}
		
		// </MODEL>
		
		// <VIEW>
		
		protected var background:Sprite;
		protected var selectionIndicator:Sprite;
		protected var itemsContainer:Sprite;
		
		// </VIEW>
		
		protected var items:Array = [];
		protected var needsLayout:Boolean = false;
		
		public function CustomComponent()
		{
			super();
			
			addEventListener(FlexEvent.PREINITIALIZE,
				function(e:FlexEvent):void
				{
					trace("PREINITIALIZE: parent = " + parent);
					trace("PREINITIALIZE: background = " + background);
					trace("PREINITIALIZE: itemsContainer = " + itemsContainer);
					trace("PREINITIALIZE: selectionIndicator = " + selectionIndicator);
				});
			
			addEventListener(FlexEvent.INITIALIZE,
				function(e:FlexEvent):void
				{
					trace("INITIALIZE: parent = " + parent);
					trace("INITIALIZE: background = " + background);
					trace("INITIALIZE: itemsContainer = " + itemsContainer);
					trace("INITIALIZE: selectionIndicator = " + selectionIndicator);
					trace("INITIALIZE: items = " + items);
				});
			
			addEventListener(FlexEvent.CREATION_COMPLETE,
				function(e:FlexEvent):void
				{
					trace("CREATION COMPLETE: parent = " + parent);
					trace("CREATION COMPLETE: items = " + items);
				});
		}
		
		override protected function createChildren():void
		{
			super.createChildren();
			
			background = new Sprite();
			background.graphics.beginFill(0xCDCDCD);
			background.graphics.drawRect(0, 0, ITEM_DIMENSION, ITEM_DIMENSION);
			background.graphics.endFill();
			background.x = background.y = 0;
			addChild(background);
			
			selectionIndicator = new Sprite();
			selectionIndicator.graphics.beginFill(0xFF0000);
			selectionIndicator.graphics.drawRect(ITEM_PADDING/2, ITEM_PADDING/2, 
				ITEM_DIMENSION - ITEM_PADDING, ITEM_DIMENSION - ITEM_PADDING);
			selectionIndicator.graphics.endFill();
			selectionIndicator.x = selectionIndicator.y = 0;
			addChild(selectionIndicator);
			
			itemsContainer = new Sprite();
			addChild(itemsContainer);
		}

		override protected function commitProperties():void
		{
			super.commitProperties();
			
			if (colorsChanged)
			{
				colorsChanged = false;
				selectedColorChanged = true;
				updateColors();
				
				needsLayout = true;
				invalidateDisplayList();
			}
			
			if (selectedColorChanged)
			{
				selectedColorChanged = false;
				if (isNaN(_selectedColor))
				{
					selectedColor = _colors[0];
				}
				else
				{
					updateSelection();
				}
			}
		}
		
		override protected function updateDisplayList(unscaledWidth:Number, unscaledHeight:Number):void
		{
			super.updateDisplayList(unscaledWidth, unscaledHeight);
			
			if (needsLayout)
			{
				needsLayout = false;
				updateLayout();
			}
		}
		
		protected function updateSelection():void
		{
			var selectedColorIndex:Number = Math.max(colors.indexOf(_selectedColor), 0);
			selectionIndicator.x = selectedColorIndex * ITEM_DIMENSION;
		}
		
		protected function updateColors():void
		{
			removeItems();
			addItems();
		}
		
		protected function addItems():void
		{
			for each (var color:Number in _colors)
			{
				var itemSprite:Sprite = createItemSprite(color);
				items.push(itemSprite);
				itemsContainer.addChild(itemSprite);
				
				itemSprite.addEventListener(MouseEvent.CLICK, handleItemClick);
			}
		}
		
		protected function removeItems():void
		{
			for each (var item:DisplayObject in items)
			{
				itemsContainer.removeChild(item);
			}
			items = [];
		}
		
		protected function createItemSprite(color:Number):Sprite
		{
			var result:Sprite = new Sprite();
			result.graphics.beginFill(color);
			result.graphics.drawRect(ITEM_PADDING, ITEM_PADDING, 
				ITEM_DIMENSION - 2 * ITEM_PADDING, ITEM_DIMENSION - 2 * ITEM_PADDING);
			result.graphics.endFill();
			return result;
		}
		
		private function updateLayout():void
		{
			var currentX:Number = 0;
			for each (var item:DisplayObject in items)
			{
				item.x = currentX;
				currentX += ITEM_DIMENSION;
			}
			
			background.width = ITEM_DIMENSION * items.length
			width = background.width;
		}
		
		protected function handleItemClick(event:MouseEvent):void
		{
			var clickedItem:DisplayObject = event.target as DisplayObject;
			var clickedItemIndex:Number = items.indexOf(clickedItem);
			
			selectedColor = _colors[clickedItemIndex];
		}
		
	}
}