package component
{
	import flash.events.MouseEvent;
	
	import mx.collections.ArrayCollection;
	import mx.core.UIComponent;
	
	import spark.components.DataGroup;
	import spark.components.supportClasses.Skin;
	import spark.components.supportClasses.SkinnableComponent;

	public class CustomSkinableComponent extends SkinnableComponent
	{
		// <MODEL>
		
		private var colorsChanged:Boolean = false;
		private var _colors:Array;
		public function set colors(value:Array):void
		{
			_colors = value;
			colorsChanged = true;
			invalidateProperties();
		}
		public function get colors():Array
		{
			return _colors;
		}
		
		// </MODEL>
		
		// <VIEW>
		[SkinPart(required="true")]
		public var background:UIComponent;
		[SkinPart(required="true")]
		public var itemsContainer:DataGroup;
		
		// </VIEW>
		
		override protected function partAdded(partName:String, instance:Object):void
		{
			super.partAdded(partName, instance);
			if (instance == itemsContainer)
			{
				itemsContainer.addEventListener(MouseEvent.CLICK, 
					function(e:MouseEvent):void
					{
						trace(e.target);
					});
			}
		}
		
		override protected function commitProperties():void
		{
			super.commitProperties();
			
			if (colorsChanged)
			{
				colorsChanged = false;
				itemsContainer.dataProvider = new ArrayCollection(_colors);
			}
		}
		
	}
}