package control
{
	import event.LoginEvent;
	
	import model.AuthenticationModel;
	import model.domain.Authentication;
	
	import mx.rpc.AsyncResponder;
	import mx.rpc.AsyncToken;
	import mx.rpc.events.ResultEvent;
	import mx.utils.StringUtil;
	
	import service.IAuthenticationService;

	public class AuthenticationController
	{
		protected var _authenticationModel:AuthenticationModel;
		public function set authenticationModel(value:AuthenticationModel):void
		{
			_authenticationModel = value;
		}
		
		protected var _authenticationService:IAuthenticationService;
		public function set authenticationService(value:IAuthenticationService):void
		{
			_authenticationService = value;
		}
		
		public function handleLogin(e:LoginEvent):void
		{
			trace(StringUtil.substitute("AuthenticationController.login(username={0}, password={1})", 
				e.username, e.password));
			
			_authenticationService.login(e.username, e.password, 
				new AsyncResponder(loginResult, loginFault));
		}
		
		protected function loginResult(result:ResultEvent, token:AsyncToken):void
		{
			trace(StringUtil.substitute("AuthenticationController.loginResult(result={0})", result));
			
			_authenticationModel.authenticated = true;
			_authenticationModel.authentication = Authentication(result.result);
		}
		
		protected function loginFault(fault:Object, token:AsyncToken):void
		{
			trace(StringUtil.substitute("AuthenticationController.loginFault(fault={0})", fault));
		}
		
	}
}