package view
{
	import event.LoginEvent;
	
	import flash.events.MouseEvent;
	
	import spark.components.Button;
	import spark.components.TextInput;
	import spark.components.supportClasses.SkinnableComponent;
	
	[Event(name="login", type="event.LoginEvent")]
	public class LoginFormComponent extends SkinnableComponent
	{
		[SkinPart] public var usernameInput:TextInput;
		[SkinPart] public var passwordInput:TextInput;
		[SkinPart] public var loginButton:Button;
		
		override protected function partAdded(partName:String, instance:Object):void
		{
			super.partAdded(partName, instance);
			
			if (instance == loginButton)
			{
				loginButton.addEventListener(MouseEvent.CLICK, handleLoginButtonClick);
			}
		}
		
		protected function handleLoginButtonClick(event:MouseEvent):void
		{
			dispatchEvent(new LoginEvent(LoginEvent.LOGIN, 
				usernameInput.text, passwordInput.text));
		}
		
	}
}