package control
{
	import event.LoginEvent;
	
	import model.AuthenticationModel;
	import model.domain.Authentication;
	
	import mx.rpc.AsyncResponder;
	import mx.rpc.AsyncToken;
	import mx.rpc.events.ResultEvent;
	import mx.utils.StringUtil;
	
	import org.swizframework.utils.logging.SwizLogger;
	
	import service.IAuthenticationService;
	
	import view.LoginForm;

	public class AuthenticationController
	{
		[Inject]
		public var authenticationModel:AuthenticationModel;
		
		[Inject(bind="true")]
		public var authenticationService:IAuthenticationService;
		
		private var logger:SwizLogger = SwizLogger.getLogger(this);
		
		[EventHandler(event="LoginEvent.LOGIN", properties="username,password")]
		public function login(username:String, password:String):void
		{
			logger.debug("AuthenticationController.login(username={0}, password={1})", username, password);
			
			authenticationService.login(username, password, 
				new AsyncResponder(loginResult, loginFault));
		}
		
		protected function loginResult(result:ResultEvent, token:AsyncToken):void
		{
			logger.debug("AuthenticationController.loginResult(result={0})", result);
			
			authenticationModel.authenticated = true;
			authenticationModel.authentication = Authentication(result.result);
		}
		
		protected function loginFault(fault:Object, token:AsyncToken):void
		{
			logger.error("AuthenticationController.loginFault(fault={0})", fault);
		}
		
	}
}