package service.proxy
{
	import flash.utils.setTimeout;
	
	import mx.core.mx_internal;
	import mx.messaging.messages.RemotingMessage;
	import mx.rpc.AbstractOperation;
	import mx.rpc.AbstractService;
	import mx.rpc.AsyncToken;
	import mx.rpc.Fault;
	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;

	public class ServiceProxy
	{
		public var service:AbstractService;
		
		public function invokeOperation(operationName:String, arguments:Array, responder:IResponder):AsyncToken 
		{
			var operation:AbstractOperation = service.getOperation(operationName);
			operation.arguments = arguments;
			
			var token:AsyncToken = operation.send();
			token.addResponder(responder);
			return token;
		}
		
		public function mockResultInvokeOperation(mockResult:Object, responder:IResponder):AsyncToken
		{
			var fakeMessage:RemotingMessage = new RemotingMessage();
			
			var token:AsyncToken = new AsyncToken(fakeMessage);
			token.addResponder(responder);
			
			setTimeout(
				function(e:ResultEvent = null):void 
				{
					token.mx_internal::applyResult(new ResultEvent(ResultEvent.RESULT, false, true, mockResult));
				}, 1000);
			
			return token;
		}
		
		public function mockFaultInvokeOperation(message:String, responder:IResponder):AsyncToken
		{
			var fakeMessage:RemotingMessage = new RemotingMessage();
			
			var token:AsyncToken = new AsyncToken(fakeMessage);
			token.addResponder(responder);
			
			setTimeout(
				function(e:ResultEvent = null):void 
				{
					token.mx_internal::applyFault(new FaultEvent(FaultEvent.FAULT, false, true, 
						new Fault("MOCK_FAULT", message)));
				}, 1000);
			
			return token;
		}
		
	}
}