package context
{
	import control.LoginCommand;
	
	import event.LoginEvent;
	
	import flash.display.DisplayObjectContainer;
	
	import mediator.LoginFormMediator;
	
	import model.AuthenticationModel;
	
	import org.robotlegs.mvcs.Context;
	
	import service.IAuthenticationService;
	import service.impl.AuthenticationService;
	
	import view.LoginForm;
	
	public class ApplicationContext extends Context
	{
		public function ApplicationContext(contextView:DisplayObjectContainer=null, autoStartup:Boolean=true)
		{
			super(contextView, autoStartup);
		}
		
		override public function startup():void
		{
			commandMap.mapEvent(LoginEvent.LOGIN, LoginCommand, LoginEvent);
			
			injector.mapSingleton(AuthenticationModel);
			injector.mapSingletonOf(IAuthenticationService, AuthenticationService);
			
			mediatorMap.mapView(LoginForm, LoginFormMediator);
		}
		
	}
}