package control
{
	import event.LoginEvent;
	
	import model.AuthenticationModel;
	import model.domain.Authentication;
	
	import mx.rpc.IResponder;
	import mx.rpc.events.ResultEvent;
	import mx.utils.StringUtil;
	
	import org.robotlegs.mvcs.Command;
	
	import service.IAuthenticationService;
	
	public class LoginCommand extends Command implements IResponder
	{
		[Inject]
		public var loginEvent:LoginEvent;
		
		[Inject]
		public var authenticationModel:AuthenticationModel;
		
		[Inject]
		public var authenticationService:IAuthenticationService;
		
		override public function execute():void
		{
			authenticationService.login(loginEvent.username, loginEvent.password, this);
		}
		
		public function result(data:Object):void
		{
			trace(StringUtil.substitute(
				"AuthenticationController.result(data={0})", data));
			
			authenticationModel.authenticated = true;
			authenticationModel.authentication = Authentication((data as ResultEvent).result);
		}
		
		public function fault(info:Object):void
		{
			trace(StringUtil.substitute(
				"AuthenticationController.fault(info={0})", info));
		}
		
	}
}