package mediator
{
	import event.LoginEvent;
	
	import flash.events.MouseEvent;
	
	import org.robotlegs.mvcs.Mediator;
	
	import view.LoginForm;
	
	public class LoginFormMediator extends Mediator
	{
		[Inject]
		public var loginForm:LoginForm;
		
		override public function onRegister():void
		{
			eventMap.mapListener(loginForm.loginButton, MouseEvent.CLICK, handleLoginButtonClick);
		}
		
		protected function handleLoginButtonClick(event:MouseEvent):void
		{
			eventDispatcher.dispatchEvent(new LoginEvent(LoginEvent.LOGIN, 
				loginForm.usernameInput.text, loginForm.passwordInput.text));
		}
		
	}
}