package bg.uni_sofia.fmi.android_2011.blue;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;

public class FirstBlueActivity extends Activity {
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.first);
        Log.v("LIFECYCLE", "Entering lifetime loop! Activity is now created!");
    }
    
    /**
	 * When an Activity is started normally, a new instance of it is created and pushed in the 
	 * current task.
	 * 
	 * Task: A (on top)
	 * A starts: A
	 * Task: A, A
	 */
    public void startFirstBlue(View v) {
    	startActivity(new Intent(this, FirstBlueActivity.class));
    }
    
    /**
     * This method and all the other button click listeners are public, because otherwise they won't
     * be able to be attached via XML.
     */
    public void startSecondBlue(View v) {
    	startActivity(new Intent(this, SecondBlueActivity.class));
    }
    
    @Override
    protected void onRestart() {
    	super.onRestart();
    	Log.v("LIFECYCLE", "Restarting, without exiting lifetime loop! Activity will become visible");
    }
    
    @Override
    protected void onStart() {
    	super.onStart();
    	Log.v("LIFECYCLE", "Entering visible loop! Activity will become visible!");
    }
    
    @Override
    protected void onResume() {
    	super.onResume();
    	Log.v("LIFECYCLE", "Entering foreground loop! Activity will be on foreground!");
    }
    
    @Override
    protected void onPause() {
    	super.onPause();
    	Log.v("LIFECYCLE", "Exiting foreground loop!");
    }
    
    @Override
    protected void onStop() {
    	super.onStop();
    	Log.v("LIFECYCLE", "Exiting visible loop!");
    }
    
    @Override
    protected void onDestroy() {
    	super.onDestroy();
    	Log.v("LIFECYCLE", "Exiting lifetime loop!");
    }
    
}