package bg.uni_sofia.fmi.android_2011.red;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;

public class RedActivity extends Activity {
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
    }
    
    /**
	 * When an Activity is started normally, a new instance of it is created and pushed in the 
	 * current task, even if the task contains Activities from another application.
	 * 
	 * Task: B1, R1 (on top)
	 * R1 starts: B2
	 * Task: B1, R1, B2
	 */
    public void startSecondBlue1(View v) {
    	startActivity(new Intent("bg.uni_sofia.fmi.android_2011.blue.ACTION_SECOND_SCREEN"));
    }
    
    /**
	 * When an Activity is started with flag for new task, a new instance of it is created and 
	 * is added to a task, different than the current one.
	 * 1. If there is an already running task, to which the new Activity has affinity, the instance 
	 * is pushed in this task and the task becomes the current one.
	 * 2. Otherwise, the instance is pushed in a new task, which becomes the current one.
	 * 
	 * Current task: R1 (on top)
	 * Other task: B1, B2
	 * R1 starts: B2
	 * New current task: B1, B2, B2
	 * Other task: R1
	 */
    public void startSecondBlue2(View v) {
    	startActivity(new Intent("bg.uni_sofia.fmi.android_2011.blue.ACTION_SECOND_SCREEN")
    		.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK));
    }
    
    /**
     * When an Activity is started with <code>android:launchMode="singleTop"</code>, if the current
     * task contains the same Activity on top, it receives the start-up Intent in a special 
     * callback, rather than creating a new instance of the same Activity.
     * This is the only difference between the standard and single-top launch modes.
     */
    public void startSingleTop(View v) {
    	startActivity(new Intent(this, SingleTopActivity.class));
    }
    
    /**
     * When an Activity is started with <code>android:launchMode="singleTask"</code>, it is always
     * started in a different task than the current one, it always has only one instance, but other
     * Activities can be started in its task.
     * When an Intent for starting such Activity is received and such Activity already exists, it
     * is brought to the front, finishing all in-between Activities, including the one on top.
     * O, rly?!
     * See http://code.google.com/p/android/issues/detail?id=11160
     */
    public void startSingleTask(View v) {
    	startActivity(new Intent(this, SingleTaskActivity.class));
    }
    
    /**
     * When an Activity is started with <code>android:launchMode="singleInstance"</code>, it is
     * always started in a different task than the current one, always has only one instance and is
     * always the only (root) Activity in its task. All Activities it starts launch in separate 
     * tasks.
     */
    public void startSingleInstance(View v) {
    	startActivity(new Intent(this, ForeverAloneActivity.class));
    }
    
}