
//	Основи на Компютърната Графика
//	Модел 10092 - Вълнолом от тетраподи
//	П. Бойчев, 2017


//Модел на пипало на тетрапод
MEIRO.TetrapodTentacle = function()
{
	THREE.Object3D.call(this);

	var body = new THREE.Mesh( MEIRO.TetrapodTentacle.geomBody, MEIRO.TetrapodTentacle.material );
	body.position.set(0,1.5,0);
	this.add(body);

	var cap = new THREE.Mesh( MEIRO.TetrapodTentacle.geomCap, MEIRO.TetrapodTentacle.material );
	cap.scale.set(1.03,0.4,1.03);
	cap.position.set(0,2.93,0);
	this.add(cap);
}
MEIRO.TetrapodTentacle.prototype = Object.create(THREE.Object3D.prototype);

//Модел на тетрапод
MEIRO.Tetrapod = function()
{
	THREE.Object3D.call(this);

	var body = new MEIRO.TetrapodTentacle();
	this.add(body);

	for (var i=0; i<3; i++)
	{
		body = new MEIRO.TetrapodTentacle();
		body.rotation.set(0,i*2*Math.PI/3,THREE.Math.degToRad(-115));
		this.add(body);
	}
}
MEIRO.Tetrapod.prototype = Object.create(THREE.Object3D.prototype);



// конструктор на модела
MEIRO.Models.M10092 = function M10092(room)
{
	MEIRO.Model.apply(this, arguments);

	// преобразувано с http://dataurl.net/#dataurlmaker
	var concreteData = 'data:image/jpeg;base64,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';
	
	var concrete = new THREE.TextureLoader().load(concreteData);
	concrete.repeat.set(3,1);
	concrete.wrapS = THREE.RepeatWrapping;
	concrete.wrapT = THREE.RepeatWrapping;
	
	var seaData = 'data:image/jpeg;base64,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';
	
	MEIRO.TetrapodTentacle.geomBody = new THREE.CylinderGeometry(0.8,1.4,3,options.lowpoly?6:15,1,true);
	MEIRO.TetrapodTentacle.geomCap = new THREE.SphereGeometry(0.8,options.lowpoly?6:15,options.lowpoly?3:4,0,2*Math.PI,0,Math.PI/2-0.2);
	MEIRO.TetrapodTentacle.material = new THREE.MeshLambertMaterial({color:'white',map:concrete});

	
	this.n = 50; // брой тетраподи
	this.breakwater = [];
	for (var i=0; i<this.n; i++)
	{
		var tetrapod = new MEIRO.Tetrapod();
		tetrapod.position.set( THREE.Math.randFloat(-5,5),THREE.Math.randFloat(-1,1),THREE.Math.randFloat(-2,2) );
		tetrapod.rotation.set( 10*Math.random(),10*Math.random(),10*Math.random() );
		tetrapod.scale.set(0.3,0.3,0.3);
		this.breakwater.push(tetrapod);
	}
	
	// вода
	this.w = 6;
	this.water = [];
	for (var i=0; i<this.w; i++)
	{
		var sea = new THREE.TextureLoader().load(seaData);
		sea.repeat.set(6,6);
		sea.wrapS = THREE.RepeatWrapping;
		sea.wrapT = THREE.RepeatWrapping;
		var material = new THREE.MeshBasicMaterial({color:'white',map:sea,transparent:true,opacity:0.3,side:THREE.DoubleSide});
		var water = new THREE.Mesh(new THREE.CircleGeometry(36,options.lowpoly?12:32),material);
		water.rotation.x = -Math.PI/2;
		water.position.y = -i/50;
		this.water.push(water);
	}
	
	var light = new THREE.PointLight('white',0.5);
	light.position.set(0,50,0);
	
	// сглобяване на целия модел
	for (var i=0; i<this.n; i++)
		this.image.add(this.breakwater[i]);
	for (var i=0; i<this.w; i++)
		this.image.add(this.water[i]);
	this.image.add(light);
	console.log(this.breakwater[0]);
}

MEIRO.Models.M10092.prototype = Object.create(MEIRO.Model.prototype);

MEIRO.Models.M10092.DIST = {MIN:10, MAX:30, HEIGHT:-1};
MEIRO.Models.M10092.POS = {DIST:20, ROT_X:1.57, ROT_Y:0.1};
MEIRO.Models.M10092.ROT_Y = {MIN:0.1, MAX:0.9};


// аниматор на модела
MEIRO.Models.M10092.prototype.onAnimate = function(time)
{
	for (var i=0; i<this.w; i++)
	{
		this.water[i].position.y = -i/50+0.2*Math.sin(rpm(time,4));
		this.water[i].material.map.offset.set(Math.sin(rpm(time+i,0.3)+i),Math.cos(rpm(time-i,0.3)+2*i));
	}
	
	reanimate();
}



// информатор на модела
MEIRO.Models.M10092.prototype.onInfo = function(element)
{
	var s = '';
	s += '<h1>Вълнолом от тетраподи</h1>';

	s += '<p>Моделът на вълнолом е от множество бетонни тетраподи. Тетраподите са от четири елемента, а те са от пресечен конус и полусфероид. По аналогичен начин &ndash; чрез йерархия на вложеност &ndash; се изграждат по-сложни обекти.</p>';
	
	element.innerHTML = s;
}
