
//	Основи на Компютърната Графика
//	Модел 10411 - Люспа от Pringles
//	П. Бойчев, 2017



// конструктор на модела
MEIRO.Models.M10411 = function M10411(room)
{
	MEIRO.Model.apply(this, arguments);

	// люспа
	// преобразувано с http://dataurl.net/#dataurlmaker
	var saltyData = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAIAAAACACAMAAAD04JH5AAADAFBMVEX////v/uLj/+z+2P3+/eD7+P385P7X/tf/3tTi6///+e392eLh//f8/+7j/+H/6N7j+P/V//nW/ujv//HM6tr7/9P+68/v6//+7/3wyP3w/tP9/L/j4P7Stcbj/8XV5v3/udHM/8rv4P//y8ni1f32//v7pbbU1f/U1t3/+NP/28Dw9//Ryf+y3P7I2P7/y9b+tcDW/r7s//z+yvnk/ta//bLW9v//7fX91e//5+rJ/9rH//rH/un+6K//zebMsN69/srKy7rMuKrI9f//4PD/8eTT5sCq/7+6+f/hyP/+uv22//Dl7svG5f6zxv7lw+/o0OPC5qiYzJ2fk/+pn/i/yeCkpNuo/9G92MnIp7++vrz8x7uprLPp/7D+s6SZ3P/v1P/Jvv/jvP+ksv3Us/yj/PvN6u2+tuz+ruji4t3+n9rs2tS9qs2ts8b+xqrdp6pywpK6sv+46v27/t3hu9vtx9SanMnrpMipxL/H/7r8/a6//pz+wezS1828xsm97MSUm7OymbK7wpHPjt382KzC1abAnqH7z5qPoP/Byvz6pPzd8vCY++ar/OS56uTg7uLapNPNyc96d8vmusTT/q2tyqv6j6mi46an+ZPw6t7/6cPbzsGXtrS3uK7bzauo/qrouamKrZbMfJbmqf7QoPumxvbv6e7Xx+GW/dCT5cXv/r+Q/aL6/Zno/Zbmo5HSgXbwtP/hlv3k4u7V1+672OT+u9+5c87l3cl2sbjXlrin4oXkp+awt+CvyNeOt8jehbmYzLjd462qtJnO0ZCI13++nvu9iPry9fCl4d2Lys//8by5hbiyfZ3S/pzOn4+Q9YeKtfyTx/v5jPvPwvGg0NP+kseTfbv+5pT6pIa1rX2U6/uKiPe2jc+p6caM/7r/jZOfuoy7dYXGwXWL2+CTut/4jd+Oh9l9ltCq2Mfl25GymY78vo2Mt3SzbWdz1czv3r96gLRslK9quG+L+/r+nvB9yK2A5KbnhIq85IO6lGi1arLbupDa7oqkn2hxXrGnWJURwe67AAAioklEQVR42kTV6XsXAgDA8c/u3+77am1ray1lrWmKUuuYUsx06FgNSZbpjkJFSikd0hxJunRTyZVuQoer5AwREsoVOXM+D4/Hq++Lzx/wBYxPdVrVFw/MKCW1PyaMosLXj4qF40GqshqGA2eMm85oRAFFTbkJAGydtCqOldzoaYh3aOIMB5q3vUy3vl7Ofu7WcAeqNQLnwA+EAxgrUgowgurxoWXS5nEO8suR04mNwU+NWKheoyIAJoPFFkQWpa1fJKDrJFD/ycY/idmUwHF0bxCrVPsC5DR5FST2tMB+PMTwsdFavk8F2wDYTrHM1N7fS2f2lTLKt2P1lw6wRpcjzE4pGwNDeuBBJGRyMqwh1LmDabXlsytXXNvVVFw+BDr4BXC5j7pia7Jih2gMVcDCqV+2BRLlwF2sJt7m19AWc3su2RmmksZLStGfEzzYmZFcx/Vg7vtaezQ6jRegN15Bvp5vIZJ4VoM+gxn8HvITcp3VDMlnrmSHtDKLcwsuZjHGIxg0fQea78I4nB5PY8C5t8/kAfj0kcxP500z0bsuBegD3A3O8kfKhqBuBx+6hCdoMXIlACmeUR7uVAqGXkMYz/FnjdAyvI49E7PglIJbocDFAIjRAnJ+3TS6o3j4ENzaZAaGoQumKEYJ7FcJZFO51FdDjZl+5Vwbu184nKWzy7ACC0ntxEwukTCYWwD0uUOHdSDqaiwzyJYs/owG3MkhytTSNQrGyZd6PkAVYJVdmFulE94OFQrDCvR1JvXZpgnQffMszNswYAWKeb2Hm2lE5m26RtxvUNkRFw8cNBDIR6G7QB0AKvTiWsFQuRBjoFvS9WENQjVIXfQNiuKnD/OpiANNpEsC7kFMY0acWmEctC2oM6kIzzx7BdwgTSnQHaXY8ZFOJT0Bgyo4aoIH4kTgPG4BB4AFfyCMlmg1BDS8UV41MA3cEOvqaEK1NVu4AJbQFLgeaOSWfnkF6u2IWwIhVdI/TBpL4eiqbxiK42pVp4xvyRSea40XDuqKGEhEx+cti9TFWPQGG43ArtPU74Qwlmo5iOaDy2hmfid+LEh8AvA0z/Zef59CmwjDeQ4DuC1cp5zECsdoqiGa4Ula4jhZk0L0Iasf6TEJSGVHFZctrafcXlobye16ohUK5G9wpbXQB/AWcsLVtRIUFxgJ8lxaiulr/vMg6GB/RR7nPqbsas4NQBJCCL8TYwigBlYBRqDEPCKI2zWBdBC9Zwu9P4vEkKuX2Qbor+Aakj2MM0arAUBX3WYxP+6z+XDyIsSj27mHi7mHNpjiedRwIjlCHkBPIWCdHXXJcGQOwNlBZCcMnKrdqiSXCXezOF9FD9x7rEgzmXipFhqjr+SDrVEFANZCzOsBAJHPSh0D5SkA4pLp4edz7pUFXr1HxWR5hIQQpkePXuh7LYLlys8c3Ob6f3g7BiF0i/jVHY0VABFfmA+YckgEhO4ek9YsBpfUQw1UyStE3f0u0I938EZLIzMXOXjCuyBWkLkm4xCmRbamNEoN4PsOvMCrF8CqBE84+wYRABdid94aPYREa7cdL8M6IS2cndH3OzQFwoH+1/lLN3wfCygWvN9y0RVSAdrqvC+qIcBailjPz/V1DJqFZ+CKJBdiO+ER+LEZCO2VAhzGQhAfhEMXyRQ6KktOKhCs9DWioX4RGrnMaqCjFh6LprYO4A/aRQDfHQHv2Es1uEnG0OWuwQB+RwJ9hbCN/Tk+hkvkaHOKdQZMPZdmJQqmQjg2rZY+0HpMZDn0zryPebHyJvn52vTSLQjljmgCNrhqm4Cdk8/EcrtLhv3Ok3Ku0FmPmPOX0zTKnwAe73ttHDCGDkm0h9oJd9hjOMys1aANuQEosaY9RdpPAhkuhJSXZYu7M1RLlubcXawyIzebNsOjmEyYPD4Z91tlVrA6X70DO/UdQs1RHmWiunVg0QU604sGgBHLMP6D2mq3LMCf84QWysiQRW8WykfYzEK1zmNPdzeymKTh1K+nNvFk9+421ANOc0gvWhAjhTc9a2tO7ZnksRMUPsieoBMPJsTRUcqUjrjwPKrOJ5zcGg8I00/xzSffoxV7E4IukNFZfCr44gxx5nAKa+FFdQAsk2SAqToA8YVFSmKl95nK+DxdNKeB4ymIgnpEI8hI8UwnK2Y5VNuirRj0cx3G864y6EwOAFcVE9xQi8Ab+0AnN0CYjCyskghlCPZVm4/SrJkhiiaW6gKG9dtX2h9lS12E2Lu2g8A9jJYgm/Xa46jzwQhAC0iW3ziVzz2CFoCweA5HEvw+IAFE6K6YHk8p44EXRqXd/QQzXebbxxzQ0WMafYrVtx34+boG+fCDeEAKy9Xk88HThXBbLOH4N3NGcNTbQLPjLbiV3chT1AugkiZpHLkG2pDI2IB5VgJBEAdKQf+naNIL005yRq6Pzl5HwAmywoXIAEBqwXzpdKmEY//T7On5bazxOQLzQ8cZom0i7iKTXWiDiWcB2GRzDVfBtLecBoO3vjuAAIAgqqZwz3wAm9cKy05WAvP6j/p3Y4B24Tv37TWhGZkbA5SzKBQugmOTAJ9hs3bIjhZlG8G8WS0Krw1kDkECgI72gaUAo3m1JbdRAe4Owhl0A+QkIAixR40DMMds54Pm3RlA6/ul5aXS5OKzP7OAXp2VWNGD6q+n0TnaMeBWXGqY0S1bK49gcqKQQozCrPZACh5evqIENEjbYu53ibg5Lp3610/fXZR/RTmAxFLsvVEoslQAdwG7h1IA7p1kuBy0Z+X9kW6ag43lGA8KQO5hzZk2lAnXHJwPfNMQwkomR+CTUW7HTK6kOrOhBW7PZKtuITbhcqEiZwnhY4zWCkbIpX70G2U7AVy1WIIkBDmVgMo6sbmY1XhXdsEtbEEayEHgLOeA/Gxov4haG3ryaJJYDYSZ9MkMrtPItghAMR9eUdtubePBopo4ssTWGWYX40ut3gSulgz+ZqvO30MgAAAMv9vsZpfZhjAtO2xZmzDMkDHMtTm2KOaKMDShNUmHSiHlSofSRXM3QlIikaJTl9Cpnm6VLl1Pz9OPfX/E+02MWOYgdUBZhO9oJDxS7k0g05Mwm3hOQ2tXtOgBgZMFNmp4XRToT1M9uATAyEUYvlrQCPcPeZ/NWAGWHZ3etkh7PavJTwBuc+m+Dmi9FCyEbZQSFY6/HuN5AKZ6o6mh4KgU439EotF7waCO1gZNydZCjFsLl8MtYqkUNrBwA/p+BtGW2AfRg8xMETMgWe303x93EQRhHg3s0PWeUGfKrzIIuc1MD7EQbUWs7nUBuMJQ7fagBTS9B+gDlPKHt/DwfMZaSGiuRgIlcOvE3VmA2g0btQbsSbFrJhpftNY0URanotuhVNa/0tPQtGiAcsqLS3ZmjDiDmGenEEJz5WhCMpKIhaEFljmnJR3QL7jRW7YDXdlpQycaTHFNFvZZZ4IMvkOGHbTpDFAfmZ2oCD3b5TVIJExNOkART2yryLMmlg4whRLOg8IBLUk/nUdrWCrNNCoe6wnXUa53MICAo8Zh0U6sg87ArUAxN2EXxmLosHcd4fLW64RhJIRYR+wJ5ruPeOO7nx+kw0hp5Hp7YvAHDmFPzZ5WzZPxtzbk5yDQFP71y3RgujrATwBI8BAA8YE8DZQ2ntl9vEkgT+Il83Hbcats8MqQhmmbCUCUFYMYOfDiLsx+EZsvAL5GwE3HiJXhjGybuPWwTKY1r2E8KhkFNNkPzCD72OP94w5li6S0CWAhIhgc+asx41rqOjKFZNim2JUDYZfLa9qH1vWB4VOfQK/d5IBjaPMmwoUxCsQ2ZyQo06Tsjgd5WcaQJ5ynuk4R6X9GeIdg7L8QLh+xaTCZBmI21v4wFkdkorbZjUDzzyiVTFO/iG5xHOEQPeUNK+AxrwHa9RACTG6IKDZb0SeduLYcuBToBlRoDXkvQXc3uBQC6WM5o7MgpFTIQ8BiXksmCJkOhsUAsM9MwEIupEnMjR8sQmE25Pj/FrM0iEOik3DsbeNECXhsGK26gq9v1niNOp/aDo9qeTU0cB5dgIdJDsNM2m8CQqHdOZwAqEkAjN1xmRi3AC7p8S2b3M+witKV9+Hf/T1+M+Y6EQwQ7Rs8VkCGQMnFW7l9uB0voMdw5lvvNjutCMLZX0G++kkAuBc+Y9GYquYeOKQaRG692rlwhN7307s04N3JMJX9woMKiMKJINMsQx9Qx02s0t118QSzVwM3t4kcA6ufGjpU+cZH6kuOdpdoOqjXiNcEB4AnTYTI7Fa9O8Jceeojtc8EVjAcTsJRoJPBJ7kYQMOXeFUVUmCERMsBAjn/q2YhVFuZWgDWG1gemWdk/7uA3nPQRSS0BuFdgNNlg1eReuYBp2bkvN8qHcxqaqh+mWLuBije3myPzgcygyiUihS2AGjMaNwnD48jELspMWz2KIDv28yogFyYn3bx2qb9vdLSc8Cg0DkTeEk1WRxhMjBHhgBIyoh1w1OptfQRpTiUboxqAL8wT5Vd7VV0KfvKtBFMwE5aEgZQYxf6HILPmME+EhDkYZW16CkLI/oHet0WeV/j6QCeA4hraqstMhRBCm8JlUwLPwHz9N0jDzI/Dnp7FjkbwGiJcEMjF/lmAMQwYTAA1x8tqiE9pH7aJCB4ky9ZNSlONnTDOEUlKw580WwdwDVg7LvNBjjM9koi08DrkhaspoQ7B41JynsxIQcK8/p8YpZboYHjuIIn3J7JjTGLYAygIyhKAf6uuBBrYM7LRsCj3YV0qzIPiJWCabpiiLmAxMvEomoYJxW+IabbnxKgfVvVMvTv+CxkOq2qa2PwrKPw0VkSA6Bn4ax6KIOj9/IxQk711GBB5uHOuSL2U+3OXh8ymoWgt0C4XwQSNsbSBRFgNg46rCNlWQJYw58aXJtVeQcgjtl8kZ26pcdvhazXd4w7gQCgMz5d8uq9fAtFgrsYHkEduk7l9bPrQH5MFpCJngXnX7Gena5EvRYCr0wDgRrBdRmY75Hq+Htd7CJhPl+vPsOAdEMsIBpOyoL9MaClTrB3D1CZmKodB3x4iQsGtO+pni3fClkThgUAmDMHtIVcZYAdD/iRMonqZ5iGYLBcmJbvq4eKbZbaqG+7H+YW7HY37X1kpSDaxwlBvqVJMOipOByL9ZPIoCTKQRUHFX4g9bTexPGyynBdDWMvAyPAFzHoC49YPJbF6TSErepNmsxEZSPwNdhijUgGMw/xFkju2L0HgPi0S2ptUbKyhBsOXQv0vaa4aTYgVi6lCDUeFzPxDxIqUvxmW2h6sCx4kJx8cCEk2RLpPZ0AItI5hY/cFgzUgsHSaiAf4GSHAvRvC6Y0XrsYR/ByIABfrAgCzC60MdCzMXdhOHfSLop+8TzY0KSp5I/LqbOOAlgeAovujSSvCfgkilyoUUwtrUAqCX4nATrjHlEY0ToV3gEkBC9i2X/OpRgL1wPJgAoA0v0dXeA5z8N158RewMeMrhyTKHb3lVh8+IFfh3SHw/3jQ4EWPKlUIMHA1I0G2l1+NybMora+uY5vBkxkgcsBv63CexCzJhszPySniDjdTf0ZMno1ilrpQ96J6Ae541AN/SnHM1cz3lQ2DwHMbekGrG4LjcuHofUAEFri1JE/r2AvYDu/Zy8BHze7BtoXIWykWSBnJUss6Xfhau9pCuormYeSRwznFMv2seBn+SUIdT26DHwHgMkXKHA76McEzI2mrhIAqq52zTAmf4pDTO/V4sHgSJNn6Vycb4mQ4hyWoPD7RKagn0C2erLc51lizj9QeI5C2DUp8nQIo+TmbJ974wfOkncCwNIEgmWfOPMVvasFgVUuPxwHZiAxgJsoBaDKI/G83mkGuK/RPMcFGBQA0rCc8DVagfDzk9w8lkd/6wWa2Qq9cbAbDZlFPXGM8nlJG5Kx+B+S6f25CwEAAPjn+92jrftu2b629iox2/hO26y+trYww8zIzhBGsuJEmVGqpdEotc2zlymKIdTJRVR0Ns/0usjVqTu56nBO3cijInd+8PkfPkkZp0TBFVQAgYdNPGlFFxYdn3j168tIKQtdXI98o/fU6xGsli2wCJLMb3XL27yUXe1KQMmwJ8Ftg5UuBTY1WrJiTQtjp/tE89RCyLJSxmFkUgAAHaIuaWolcH/KlKX2EyzJ4/CkNwHy5DR5Dzg4Ks2SLP/A9S4GnRZjVJQeVbBcH9zA1HPsH/NGqlqyznb5ZRGTKMB6XAi+V+b9kdiJC1/t/wbQwi0q+414ds/co/zGBTWlJOI6Mff2wZveJYkHHeA15kFPIej08M2sSIWYRZsZGoplVYzwzAzUI5Gd2EzcZJCAF1EM+fH43EjSx4pEmRlAPUR6AF/Mg/sy4hwEQ1A3xNfkkAFc8AJaCEkgD+eijn5Iz43pxvoIaThH+DweGAjZ3M043bAtbpqktSTqKP2FLpRKWEgKeh91+kMF2wnO5iyUfWQyj3T+ccR78QDYkQtwZ0w5GgLFYaV5qVMXmeJ6QehOOjX+DcMA7m6CLDCbNlepR/tuVhkaAlFk+wy6u6kVy0VVqKkt/MEm1asA5Ot/Aib4+isIvmaMMcxA5s3W5G+R/wiKAyJYX/AcPG8Gd6EBkFAuFQyfBKy2P8EGf/Zbfr7xFVaGBj1PuqNnFy5mVScAOQy5YbzkgTVoTJ47uPJ+nJtJS9M2Ho2VqmqOWLFAFEbeyC0J+iRPxjRP0gCjKIiGz3Ha9hPqKgZhWQa4lApgn/2qQbAYKFI1NIAxwxONOI4tH/bsToNEBF3lJthAI/OVHyL3sbR44tkA7Br9bi5sFfLWAiSdSOTokP+vY9cCuaax9327uXX5ywDa8DZXwLFZlpirMgOJ2umFq73YeBrKJMLtwGxS02hz9gsIukeuYZLngG0UAQwTudIXlfAd+pZuzAb4929soAa8otXfnwGzkgFgHWX2EMZqWr45U5s6dfnVqSaATwB6vz0xMAGMw5xD39HbWKWiXLqCImqdcgPOICByLI5fkcN1OvATRg8EHSOPwLSgrRYausxsnQ7ZDsZO4CqrPUMX7UYfVEn0cdQhswl7Sh761KfIAsdx3s9QF0v8PG7XDGtlQjkghV32bX2MlC53zBPC78y/RzgZeNUgeBr8zDqcCYs9QKstNXSgVV4c3MqAiB0cKCs9azENPH5FiSKDwbqPSy4CqP5dOaS15BaTNOP8Ndh0zelQAhKehgG5LNBFlbXYK/IK6BGgGeEjiZCDp6wsuiAI0LDXO074YMB0tIuH2jAC34LmHV/BzD45cLiXG6/NRpv7bGyeC1H40U4HBlvpJhgfFkRIvrsKs1xmeI8iZ7Xgo30lKCGDeEaM+JK/shjruokqAZcWkgI93EpoHGABbGSmhYBzdRnE8FneAa4mJcGZADhZVgxTKi5mAKPSl3ARVKODY9r746mYDg++tZmT/uOw3p+7EAAAgH9s39nWJBpj6ztbm+y79moe3/lO2TRLE2udedS1ZS0tFVHtNkujBzJdtmOorKgIUdcIt1NZdRh5NeZZKtdxch55HIc7x9/w+eXzTDIRBWS4ziKn3LfhpHFNzIHfswGx3MsFm1zPE1C7QxRF9nmZGeR20Lgm2hcZVpaOSWntKUW1GHMsG0nlEk9tIAw4neXPg4VUT8bvEVLPvmaxPhpp+GYA4Cz+ZEI1ZiIOs3zYBhnqB4EfgFsZ72tgRJdMqPPgxt488Am7YzHhrjBGA150FihZgKRpvZiuyedLapQ1ZIH8pz2iLKfLcgcAFUOMNSy9FRytYO5wnFlaGFSayya7tA1dw/flxGwZ9Dp4Nk3CPeZDPVSUgoREcNmpfIYp7S+JGkLQ1p8XwEMwi2zaP4K602DhEaAJ+dNj3bhV0QqwCo+ARnJwlPscgD0HIcBETPpLIEEatWAyQHvioNyFVJnYwxhBFLVg70/28azoB6clcYaiu2Vx7BKuGT34Pz/T58FE6P01GYBm70AKJ/cZxefcAfl84j2jOY5loB6WqkQm5SrujMoYodLtcoTqKWG/+M2WOgwMOwIiRulyygC7E6AcRg7HXIZ6SyeAKk4UyMUSnWwE+Zdz2bhz4UdumxOgkcudvsBOY1nIdlAQRVHr/7uMtaOi10VIvIx0mXkEaQvkBpjNCeoAaSJskJIJqk53OAWQafgIGOsMnqjOOSMMJQzD0b8LjmXwnWZMwXwAyNLB2ydxmGRjjFuZBBeL61O7B84F4LmHVxMlDZOQzsyA9o/thzMzHmcwO88BsPY860f9otWq9ylm+CUGi2lRDpoZdyhZfSAadYVarvBCf7cAJBL+9A9Xug1P2qu7s9daFkluJMRNHHIzBGIOaAG7lSum00zPd3O2CQNm9X/XlIqeEIIlFJczmUZ0a4YEH25q5RQMQR43IF8e23wvFSwNXgf5iNGPAfWiGUgJ7fWVaJAQMsShWAizeQZRE7dZT8MbjuB9rjLNdKHtU5lrHYtEKAaPkQrCmOR8jI4oVRlnj2Xb3zUU8sTzD7XJggBIBG01b+iC/tOS/L/1MThxuUKEwS5LcX6aPg+AZebGUPNauuw0phALI2twIXC4B5S5nqtBM4+vd3aLZL5EraDzESdk8ajVIwFumPXSOVbjoFqAx2QlzEQtOn0K0qs76jCfNFihTx2hmzbOcBzAeAKwmL0E6cdUEm154WTAqz5QNdjLoIDgjm7MORUPmweu9RD3Wn6R8Yhau1MJm9sB3AFkb4kHx8XpBQBVq3DwZN47axchoGNQLOyAKJFVj07lUrV1jq272doOImA2W81uy/EUWurmrbkfCJcNTXmO31YQWQcA80A0vwJ3Oq6gxqviJEGe2LIvvimmGLABSbpuBKnxzeDvMD9p0LevMiUrGsnTGOt27M+Hwtfc4pwnvYJv1ynMYw0ME8Ob72Y34cp4RTHYxgQATtLTwOqV9AiMIONfLuu0JwsCAADwg6DIHYeB+IKEUEQjI1/sICp0KhZFB2TF4SoxwszwyDQJw3rVWZKaYk6XNsqZWkZaqV0murJWNkkz3DpseTTtTptdX/pSz694ZqPHN5o0eeITPBdOu/hwl0fD5l9gcqu8AXw3olccH5BO4NV4XAqbpeWx+g5nYS5YLqlLg2ZvuxicEojUsk8TNQT295Vbrkxl0w8oY4iT3gfi5EawclxHAeeqvioReeEYyAqNnCMVDLKj8S1KK6JQkW2BGbkgZF8/bjG6J4WOu2/1zuscK/CUHEtCioReTjSA2klakMMMSC4MI9lEZDAbEUMtA6ztQGbyWebD02INeM6nWBHHC5YBgGc6t5fKO4/rGOTfL25gfL0azkI+fd04BdCGxiq3bdIau20mYFbgFY2qxCMHf9w5xDAysHDO3uGOpy+DLW/M93NBkZarJw2ORt1YUIgYpicTxxm4blXJIAC4EmGYxZB4eidSKZBy+e1DMIFyYRANS3hbBFz3CvDg+QCcz/4PV002FftgDdmgAVM28poJjDqSv6jLyzpugvRRf0m4jXP5bWD+FQ7DFtGuRwoVhwHOPJ7QpuB2/zPXAaQCNQiLaj6OJDH9jWQ5MVX2rmwTJiOVLnK4hEqEYSAFgDpOyGy+u4kKDCowHQU07JHxOC0cJxw/fs8D/dLcxfMRt0QRjoiYoXvcfAE8iNASjjLPjIuKMc8j6isLQ9fG8ZrKSXAfDeRiCWMKw4vs0SNdu3rWMy2TFlzhGqymxlcstIvUvEXK0W+q2a5ed3a8BWRxci7odNDYRnKYiV4JvmDa2PNklIDBtK/bGTeAFZ3FAEnuRAZwUQp2m3EtQSMjPhb4ejsll4mvNv7YZcHltGZyyG0uky9W91SwGYCdop7XG7EzQRCHxsfOZQTgqOwCnsgF1HAOIWal9hEAUFyi6AQPz+ehWGOKrQdERN4EpY/SxGfUl+MUIAV4SeRGFC03XB/aiLaR87JV80K9YUk7GD0CT0oEcKgcQH/Z50C1MIJOV+049hWTG2Ui6RgqU7vZ5VIRSmHNQTF+5QEHel61AEyIvAoUqXUDdYDh0b1DFAOjcNdCrALMI4ithcAPa1CbdhHsSgWNxQDcCMnlWAyu0NnXNQ1MxVINmllK+4ZtQEUaDJWRX4dLjbHJdmMmFnMvCcikfXAVIlWAcMkODxtY70vXLl6MOdYLAq3oTZos6Wcgk6fupBM81o3YW4CzUSMdVM9KeLMU3UAfjJ6ogw+36TL97OFCWoixD2AsG6A/ACt6RJV0O7Gom3CWTsRI1LrabugMR87FmyBmGcFcEOZ3G6esQ60YGMdagfsZQY6tGodaVc9NsJaSZ/32p9AjcX8jiHSRTuIUAPjIzYm9SML1yKLPF0bC53IBB4fBXVvT3ttypAxcKL6/aRJ4CBfYQJ3T1d6il3ev6RpdtuBR7Ad2Eo02VnLJrXO64q8vhSNH+4GfCKIMV+oLeFGz3add6I8Du/MNhtiAvZzfGhE0Lgtk0Qaj/Nc9ovEpvrXGJVjtn6rrskcHAAAA8KO9uk6ceNXpOo7TzanT3d3d3d0dY7q7mZ7u3oxhmG6GjY354ovnXzxjZ7dK9wE8EAL9BIDb24Q+YIXXVvK6FHHogphxM4vWPwdkV4+4KEH6uLbpRkvl2B8vUPjT5rjFXU/X9qq8IUU7xr4glDjg5sdXqRxLKa05AuBb9ivh6IInpa1m+/ORhSheyR9WQZ/WyDGOUjgZKLOir/QLb2Y2MZblaYDIGmWIJBcN0asaQ6HBrCg4A3SmFFNQWV6sIiw6PHlhtQ/azC2Rs16Sxha4LN5hp700Nim3+Y2RASBDixwBa0Wgm/Wa50ufEsiSv0/CeQlQmuGgJq5V1wurgprLRveW1H/iB+7GSowfiM8KNIyBTWAPoFwYwu0sBFADg2wd3IqDizJ/lIpZ4kNngP1iunhsw1W1fsolBsnb0+dL+IbsRO3+nu/AWyQjTSqAFX1RPA2Y7nVcFL0Pc4qQYppHegLCeAOnUbW+E1lEY+2jrKSLqSyanAkZEgSplTuVTAaJjFICdYEKCojfAUNW5kuaQI+r2B+zM0diMsNx57/Kay3AIUICmg6WCCajGShDq2udwIzn6DAwBCCX8ljsIQpTemCNlGBpdCV0dQhbFZkoWfnyJGtxB0PaUYRVUNXiFNvpRcX24IsRNxLt5SyghrHUgOBhhk2wQLy7QKHVtE0GBCGBysRsiEuTXLVhrESVQYIQiC+uXbCDfLGhMvyAxtpvBNFALPoBIZDdAgOX34RIdgEHRYRqJQxJ+YZMKWB3xHUOfagrFSLpRFaY+d5lsctMRTwC+kLO8CIGAzRA3kaYQSy1ZQwdkEDjRYZHfYZ+bCM0AirqBXinZIQIdV2aAM0oBGmZi5rclhgUW1YFagaNnWo1knKlFOLEPkYQoBxk6kdHua8C3DfQWzqS0hVip6dRNfN3gY44/rNnBdA2IHCQNhgDIJJ7g6mrEX6lErWuDbPAc4jBFWzJArzJd36nip2hHVM0WJYRvWOwQuzixTDUUpMZj1jbPcuNqNUdgafG8MFRCNMMNI2WBKAmXkECbOxkSYwY5DdPTPEkXChVN+B7KRALQwE+mG41noeRuMxb4CRIBcDEeJPakpWADB72iZD4cY2SUADMJOcNaqoAE2AN3HU7C86d05I4lIJBhqp6enI5wHg5MIDZeuZRWRJKRI3RQxWCVwBs1g/gGHAPl9SlF+k2g1oxuMDoBujSxgDPOwKd/NvF0zyN4SPoFJ2aSYMz3oOMYewSOZctGz0ABLSowy3/S90QjJAF2ZdmEierFY5JIgIqIAhguk/NSjRVhIzQ2joAiRIURHekAbtTZIgDjAaUlN6+8NG5YzG/H65JDFGqet7WIUap3E1iYfygviRm9yaTLuEQ26zQAYIjnMUEk1kIc5N6Nb6qlRZrgNB3UEQ8xV+gp79OkfCBsYZj+gAAAABJRU5ErkJggg==';
	var salty = new THREE.TextureLoader().load(saltyData);
	salty.repeat.set(1/2,1/2);
	salty.wrapS = THREE.RepeatWrapping;
	salty.wrapT = THREE.RepeatWrapping;
	salty.anisotropy = 8;

	var geometry = new THREE.ParametricGeometry(this.calculate,60,15);
	var material = new THREE.MeshLambertMaterial({color:'yellow',side:THREE.DoubleSide,map:salty});
	this.pringle = new THREE.Mesh(geometry,material);
	
	for (var i=0; i<geometry.faces.length; i++)
	{
		var face = geometry.faces[i];
		var uvs = geometry.faceVertexUvs[0][i];
		
		uvs[0].x = geometry.vertices[face.a].x;
		uvs[0].y = geometry.vertices[face.a].z;
		
		uvs[1].x = geometry.vertices[face.b].x;
		uvs[1].y = geometry.vertices[face.b].z;
		
		uvs[2].x = geometry.vertices[face.c].x;
		uvs[2].y = geometry.vertices[face.c].z;
	}

	light = new THREE.AmbientLight('red',0.2);
	
	// сглобяване на целия модел
	this.image.add(this.pringle,light);
}

MEIRO.Models.M10411.prototype = Object.create(MEIRO.Model.prototype);

MEIRO.Models.M10411.DIST = {MIN:10, MAX:30, HEIGHT:0};
MEIRO.Models.M10411.POS = {DIST:15, ROT_X:0.5, ROT_Y:0.5};
MEIRO.Models.M10411.ROT_Y = {MIN:-0.1, MAX:0.7};


// генератор на модела
MEIRO.Models.M10411.prototype.calculate = function(u,v)
{
	var R = v;
	var a = (2*Math.PI)*(u+v/8);
	
	var x = 4*R*Math.cos(a);
	var z = 3*R*Math.sin(a);
	var y = x*x/16-z*z/9;
	
	return new THREE.Vector3(x,y,z);
}


// аниматор на модела
MEIRO.Models.M10411.prototype.onAnimate = function(time)
{
	this.pringle.rotation.x = rpm(time,5);
	this.pringle.rotation.y = rpm(time,8);
	this.pringle.rotation.z = rpm(time,3);
	
	reanimate();
}



// информатор на модела
MEIRO.Models.M10411.prototype.onInfo = function(element)
{
	var s = '';
	s += '<h1>Люспа от Pringles</h1>';

	s += '<p>Тази люспа от Pringles е фрагмент от хиперболичен параболоид &ndash; параметричен обект с уравнение при <em>r∈[0,1]</em> и <em>α∈[0,2π]</em>:</p>';
	s += '<p style="margin-left:1em; padding-left:0.5em; border-left:solid 0.05em cornflowerblue;"><em>x = 4r.cos(α)<br>y = r<sup>2</sup>[cos<sup>2</sup>(α)-sin<sup>2</sup>(α)]<br>z = 3r.sin(α)</em></p>';
	
	element.innerHTML = s;
}
