package net.asteasolutions.aos;

import android.app.ListActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.ListView;

/**
 * The sole {@link ListActivity} of our application, which initializes the UI on the screen and 
 * reacts on user interaction, by loading the corresponding data from the model. Because it is 
 * {@link ListActivity}, it automatically uses the {@link ListView} with <code>android:list</code> 
 * ID from its content layout.
 */
public class ListDemoActivity extends ListActivity {

    private ViewModel model;
    private UberAdapter adapter;
    
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        
        // Create new model, which will be used to request and access all our data.
        this.model = new ViewModel();
        // Create new adapter, which will be used with the ListActivity's ListView.
        this.adapter = new UberAdapter(this, -1, this.model.getItems());
        // Start listening for model changes in the adapter.
        this.model.addObserver(this.adapter);
        
        // Because this is ListActivity, we can directly set the adapter with a custom method.
        // If we had used a simple Activity, we would have had to set the adapter to the adapter 
        // view with a method of AdapterView<T>.
        setListAdapter(this.adapter);
    }
    
    public void fooClicked(View target) {
        this.model.requestFoo(this);
    }
    
    public void barClicked(View target) {
        this.model.requestBar(this);
    }
}