package net.asteasolutions.aos;

import java.util.ArrayList;
import java.util.Observable;

import android.content.Context;

/**
 * Abstraction of the data that we will be using. The ViewModel class can request data from 
 * remote location (resource file in our case) and can notify for eventual changes. In order to be
 * able to notify listeners, it extends the {@link Observable} util class.
 */
public class ViewModel extends Observable {
    
    private final ArrayList<ListItem> items = new ArrayList<ListItem>();
    
    /**
     * Getter for all the items, which constitute the model.
     * 
     * @return an {@link ArrayList} of all the {@link ListItem}s, that we will be consuming.
     */
    public ArrayList<ListItem> getItems() {
        return this.items;
    }
    
    /**
     * Requests all the data from the "foo" repository (just the items in R.array.foo in our case).
     * 
     * @param context a {@link Context}, used for obtaining Android resources.
     */
    public void requestFoo(Context context) {
        request(context, R.array.foo);
    }

    /**
     * Requests all the data from the "bar" repository (just the items in R.array.bar in our case).
     * 
     * @param context a {@link Context}, used for obtaining Android resources.
     */
    public void requestBar(Context context) {
        request(context, R.array.bar);
    }

    private void request(Context context, int arrayId) {
        String[] values = context.getResources().getStringArray(arrayId);
        
        this.items.clear();
        
        for (String value : values) {
            ListItem item = new ListItem();
            item.setTitle(value);
            this.items.add(item);
        }
        
        itemsChanged();
    }
    
    private void itemsChanged() {
        setChanged();
        notifyObservers();
    }
    
}
