//
//  RootViewController.m
//  NavigationTestApp
//
//  Created by Dobrin Dobrev on 11/9/11.
//  Copyright (c) 2011 __MyCompanyName__. All rights reserved.
//

#import "RootViewController.h"
#import "ViewControllerWithText.h"
#import "NewRootViewController.h"

@implementation RootViewController

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
    }
    return self;
}

- (void)didReceiveMemoryWarning
{
    // Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
    
    // Release any cached data, images, etc that aren't in use.
}

#pragma mark - View lifecycle

- (void)item1tapped {
    NSLog(@"item1 tapped");
}

- (void)item2tapped {
    NSLog(@"item2 tapped");
}

- (void)item3tapped {
    NSLog(@"item3 tapped");
}

- (void)changeTitle {
    self.title = @"newTitle";
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    UIBarButtonItem *toolbarItem = [[UIBarButtonItem alloc] initWithTitle:@"item1" style:UIBarButtonItemStylePlain target:self action:@selector(item1tapped)];
    
    UIBarButtonItem *toolbarItem2 = [[UIBarButtonItem alloc] initWithTitle:@"item2" style:UIBarButtonItemStyleBordered target:self action:@selector(item2tapped)];
    
    UIBarButtonItem *toolbarItem3 = [[UIBarButtonItem alloc] initWithTitle:@"item3" style:
        UIBarButtonItemStyleDone target:self action:@selector(item3tapped)];
    
    UIScrollView *toolbarItem4View = [[UIScrollView alloc] initWithFrame:CGRectMake(0.0, 0.0, 100.0, 40.0)];
    toolbarItem4View.contentSize = CGSizeMake(300.0, 40.0);
    toolbarItem4View.pagingEnabled = YES;
    toolbarItem4View.backgroundColor = [[UIColor blueColor] colorWithAlphaComponent:0.5];
    
    UIBarButtonItem *toolbarItem4 = [[UIBarButtonItem alloc] initWithCustomView:toolbarItem4View];
    
    self.toolbarItems = [NSArray arrayWithObjects:toolbarItem,toolbarItem2,toolbarItem3,toolbarItem4,nil];
    self.navigationController.toolbarHidden = NO;
    // Do any additional setup after loading the view from its nib.
    
//    UIView *titleView = [[UIView alloc] initWithFrame:CGRectMake(0.0, 0.0, 1360.0, 170.0)];
//    titleView.backgroundColor = [[UIColor magentaColor] colorWithAlphaComponent:0.8];
//    
//    self.navigationItem.titleView = titleView;
    self.navigationItem.leftBarButtonItem = [[[UIBarButtonItem alloc] initWithTitle:@"left" style:UIBarButtonItemStylePlain target:self action:@selector(changeTitle)] autorelease];
//    [titleView release];
    
    toggleVisibilitySwitch.on = !self.navigationController.isNavigationBarHidden;
    toggleToolbarVisibilitySwitch.on = !self.navigationController.isToolbarHidden;    
    
}

- (void)viewDidUnload
{
    [super viewDidUnload];
    // Release any retained subviews of the main view.
    // e.g. self.myOutlet = nil;
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    // Return YES for supported orientations
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}

-(IBAction)addModalViewController:(id)sender {
    UIViewController *newViewController = [[ViewControllerWithText alloc] initWithNibName:@"ViewControllerWithText" isModal:YES];
    newViewController.title = @"Modal";
    [self presentModalViewController:newViewController animated:YES];
    [newViewController release];
}

-(IBAction)addNonModalViewController:(id)sender {
    UIViewController *newViewController = [[ViewControllerWithText alloc] initWithNibName:@"ViewControllerWithText" isModal:NO];
    newViewController.title = @"rvc69";
    [self.navigationController pushViewController:newViewController animated:YES];
    [newViewController release];
}

-(IBAction)addRootViewController:(id)sender {
    static int rvcNo = 0;
    if (rvcNo == 68) {
        rvcNo++;
    }
    RootViewController *rootViewController = [[RootViewController alloc] initWithNibName:@"RootViewController" bundle:nil];
    rootViewController.title = [NSString stringWithFormat:@"rvc%d",++rvcNo];
    [self.navigationController pushViewController:rootViewController animated:YES];
    [rootViewController release];
}

-(IBAction)toggleNavBarVisibility:(id)sender {
    [self.navigationController setNavigationBarHidden:!self.navigationController.isNavigationBarHidden animated:YES];
}

-(IBAction)popToRoot:(id)sender {
    [self.navigationController popToRootViewControllerAnimated:YES];
//    [self.navigationController popViewControllerAnimated:YES];
}

-(IBAction)changeViewControllers:(id)sender {
    NewRootViewController *rootViewController = [[NewRootViewController alloc] initWithNibName:@"NewRootViewController" bundle:nil];
    [self.navigationController setViewControllers:[NSArray arrayWithObject:rootViewController] animated:YES];
    [rootViewController release];

}

-(IBAction)toggleToolbarVisibility:(id)sender {
    [self.navigationController setToolbarHidden:!self.navigationController.isToolbarHidden animated:YES];
}

@end
