//
//  ThirdViewController.m
//  TabBarTestApp
//
//  Created by Dobrin Dobrev on 11/9/11.
//  Copyright (c) 2011 __MyCompanyName__. All rights reserved.
//

#import "ThirdViewController.h"
#import "SecondViewController.h"

@implementation ThirdViewController

-(void)selectHidden {
    tabBarController.selectedViewController = [tabBarController.viewControllers lastObject];
}

-(IBAction)addBatmen:(id)sender {
    int numberOfBatmen = [batmenCount.text intValue];
    if (numberOfBatmen<2) {
        UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"Error" message:@"Not enough batmen" delegate:nil cancelButtonTitle:@"OK" otherButtonTitles: nil];
        [alert show];
        [alert release];
        return;
    }
    NSMutableArray *newViewControllers = [[NSMutableArray alloc] initWithCapacity:numberOfBatmen];
    int x = 0;
    for (int i=0;i<numberOfBatmen;i++) {
        UITapGestureRecognizer *tapGR = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(selectHidden)];
        NSString *title = [NSString stringWithFormat:@"Batman%d",i];
        UITabBarItem *batmanItem = [[UITabBarItem alloc] initWithTitle:title image:[UIImage imageNamed:@"batman.png"] tag:i];
        UIViewController *vc = [[UIViewController alloc] init];
        vc.title = title;
        if ((x++)%2 == 0) {
            vc.view.backgroundColor = [UIColor redColor];
        } else {
            vc.view.backgroundColor = [UIColor greenColor];
        }
        vc.tabBarItem = batmanItem;
        [vc.view addGestureRecognizer:tapGR];
        [newViewControllers addObject:vc];
        [batmanItem release];
        [vc release];
    }
    
    [tabBarController setViewControllers:newViewControllers animated:YES];
    [newViewControllers release];
}

-(BOOL)textFieldShouldReturn:(UITextField *)textField {
    [textField resignFirstResponder];
    return YES;
}

@end
